// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Monitor.Models
{
    /// <summary> Operator for dimension values. </summary>
    public readonly partial struct MonitorDimensionOperator : IEquatable<MonitorDimensionOperator>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MonitorDimensionOperator"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MonitorDimensionOperator(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string IncludeValue = "Include";
        private const string ExcludeValue = "Exclude";

        /// <summary> Include. </summary>
        public static MonitorDimensionOperator Include { get; } = new MonitorDimensionOperator(IncludeValue);
        /// <summary> Exclude. </summary>
        public static MonitorDimensionOperator Exclude { get; } = new MonitorDimensionOperator(ExcludeValue);
        /// <summary> Determines if two <see cref="MonitorDimensionOperator"/> values are the same. </summary>
        public static bool operator ==(MonitorDimensionOperator left, MonitorDimensionOperator right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MonitorDimensionOperator"/> values are not the same. </summary>
        public static bool operator !=(MonitorDimensionOperator left, MonitorDimensionOperator right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MonitorDimensionOperator"/>. </summary>
        public static implicit operator MonitorDimensionOperator(string value) => new MonitorDimensionOperator(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MonitorDimensionOperator other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MonitorDimensionOperator other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
