// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.ResourceManager.Monitor.Models
{
    /// <summary> Dimension splitting and filtering definition. </summary>
    public partial class MonitorDimension
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MonitorDimension"/>. </summary>
        /// <param name="name"> Name of the dimension. </param>
        /// <param name="operator"> Operator for dimension values. </param>
        /// <param name="values"> List of dimension values. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="name"/> or <paramref name="values"/> is null. </exception>
        public MonitorDimension(string name, MonitorDimensionOperator @operator, IEnumerable<string> values)
        {
            Argument.AssertNotNull(name, nameof(name));
            Argument.AssertNotNull(values, nameof(values));

            Name = name;
            Operator = @operator;
            Values = values.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="MonitorDimension"/>. </summary>
        /// <param name="name"> Name of the dimension. </param>
        /// <param name="operator"> Operator for dimension values. </param>
        /// <param name="values"> List of dimension values. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MonitorDimension(string name, MonitorDimensionOperator @operator, IList<string> values, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            Operator = @operator;
            Values = values;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="MonitorDimension"/> for deserialization. </summary>
        internal MonitorDimension()
        {
        }

        /// <summary> Name of the dimension. </summary>
        public string Name { get; set; }
        /// <summary> Operator for dimension values. </summary>
        public MonitorDimensionOperator Operator { get; set; }
        /// <summary> List of dimension values. </summary>
        public IList<string> Values { get; }
    }
}
