// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Monitor.Models
{
    /// <summary> The MonitorDayOfWeek. </summary>
    public readonly partial struct MonitorDayOfWeek : IEquatable<MonitorDayOfWeek>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MonitorDayOfWeek"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MonitorDayOfWeek(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SundayValue = "Sunday";
        private const string MondayValue = "Monday";
        private const string TuesdayValue = "Tuesday";
        private const string WednesdayValue = "Wednesday";
        private const string ThursdayValue = "Thursday";
        private const string FridayValue = "Friday";
        private const string SaturdayValue = "Saturday";

        /// <summary> Sunday. </summary>
        public static MonitorDayOfWeek Sunday { get; } = new MonitorDayOfWeek(SundayValue);
        /// <summary> Monday. </summary>
        public static MonitorDayOfWeek Monday { get; } = new MonitorDayOfWeek(MondayValue);
        /// <summary> Tuesday. </summary>
        public static MonitorDayOfWeek Tuesday { get; } = new MonitorDayOfWeek(TuesdayValue);
        /// <summary> Wednesday. </summary>
        public static MonitorDayOfWeek Wednesday { get; } = new MonitorDayOfWeek(WednesdayValue);
        /// <summary> Thursday. </summary>
        public static MonitorDayOfWeek Thursday { get; } = new MonitorDayOfWeek(ThursdayValue);
        /// <summary> Friday. </summary>
        public static MonitorDayOfWeek Friday { get; } = new MonitorDayOfWeek(FridayValue);
        /// <summary> Saturday. </summary>
        public static MonitorDayOfWeek Saturday { get; } = new MonitorDayOfWeek(SaturdayValue);
        /// <summary> Determines if two <see cref="MonitorDayOfWeek"/> values are the same. </summary>
        public static bool operator ==(MonitorDayOfWeek left, MonitorDayOfWeek right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MonitorDayOfWeek"/> values are not the same. </summary>
        public static bool operator !=(MonitorDayOfWeek left, MonitorDayOfWeek right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MonitorDayOfWeek"/>. </summary>
        public static implicit operator MonitorDayOfWeek(string value) => new MonitorDayOfWeek(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MonitorDayOfWeek other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MonitorDayOfWeek other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
