// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Monitor.Models
{
    /// <summary> the sensitivity of the baseline. </summary>
    public readonly partial struct MonitorBaselineSensitivity : IEquatable<MonitorBaselineSensitivity>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MonitorBaselineSensitivity"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MonitorBaselineSensitivity(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string LowValue = "Low";
        private const string MediumValue = "Medium";
        private const string HighValue = "High";

        /// <summary> Low. </summary>
        public static MonitorBaselineSensitivity Low { get; } = new MonitorBaselineSensitivity(LowValue);
        /// <summary> Medium. </summary>
        public static MonitorBaselineSensitivity Medium { get; } = new MonitorBaselineSensitivity(MediumValue);
        /// <summary> High. </summary>
        public static MonitorBaselineSensitivity High { get; } = new MonitorBaselineSensitivity(HighValue);
        /// <summary> Determines if two <see cref="MonitorBaselineSensitivity"/> values are the same. </summary>
        public static bool operator ==(MonitorBaselineSensitivity left, MonitorBaselineSensitivity right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MonitorBaselineSensitivity"/> values are not the same. </summary>
        public static bool operator !=(MonitorBaselineSensitivity left, MonitorBaselineSensitivity right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MonitorBaselineSensitivity"/>. </summary>
        public static implicit operator MonitorBaselineSensitivity(string value) => new MonitorBaselineSensitivity(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MonitorBaselineSensitivity other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MonitorBaselineSensitivity other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
