// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.Monitor.Models
{
    /// <summary> An azure function receiver. </summary>
    public partial class MonitorAzureFunctionReceiver
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MonitorAzureFunctionReceiver"/>. </summary>
        /// <param name="name"> The name of the azure function receiver. Names must be unique across all receivers within an action group. </param>
        /// <param name="functionAppResourceId"> The azure resource id of the function app. </param>
        /// <param name="functionName"> The function name in the function app. </param>
        /// <param name="httpTriggerUri"> The http trigger url where http request sent to. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="name"/>, <paramref name="functionAppResourceId"/>, <paramref name="functionName"/> or <paramref name="httpTriggerUri"/> is null. </exception>
        public MonitorAzureFunctionReceiver(string name, ResourceIdentifier functionAppResourceId, string functionName, Uri httpTriggerUri)
        {
            Argument.AssertNotNull(name, nameof(name));
            Argument.AssertNotNull(functionAppResourceId, nameof(functionAppResourceId));
            Argument.AssertNotNull(functionName, nameof(functionName));
            Argument.AssertNotNull(httpTriggerUri, nameof(httpTriggerUri));

            Name = name;
            FunctionAppResourceId = functionAppResourceId;
            FunctionName = functionName;
            HttpTriggerUri = httpTriggerUri;
        }

        /// <summary> Initializes a new instance of <see cref="MonitorAzureFunctionReceiver"/>. </summary>
        /// <param name="name"> The name of the azure function receiver. Names must be unique across all receivers within an action group. </param>
        /// <param name="functionAppResourceId"> The azure resource id of the function app. </param>
        /// <param name="functionName"> The function name in the function app. </param>
        /// <param name="httpTriggerUri"> The http trigger url where http request sent to. </param>
        /// <param name="useCommonAlertSchema"> Indicates whether to use common alert schema. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MonitorAzureFunctionReceiver(string name, ResourceIdentifier functionAppResourceId, string functionName, Uri httpTriggerUri, bool? useCommonAlertSchema, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            FunctionAppResourceId = functionAppResourceId;
            FunctionName = functionName;
            HttpTriggerUri = httpTriggerUri;
            UseCommonAlertSchema = useCommonAlertSchema;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="MonitorAzureFunctionReceiver"/> for deserialization. </summary>
        internal MonitorAzureFunctionReceiver()
        {
        }

        /// <summary> The name of the azure function receiver. Names must be unique across all receivers within an action group. </summary>
        public string Name { get; set; }
        /// <summary> The azure resource id of the function app. </summary>
        public ResourceIdentifier FunctionAppResourceId { get; set; }
        /// <summary> The function name in the function app. </summary>
        public string FunctionName { get; set; }
        /// <summary> The http trigger url where http request sent to. </summary>
        public Uri HttpTriggerUri { get; set; }
        /// <summary> Indicates whether to use common alert schema. </summary>
        public bool? UseCommonAlertSchema { get; set; }
    }
}
