// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Monitor.Models
{
    /// <summary> The Azure mobile App push notification receiver. </summary>
    public partial class MonitorAzureAppPushReceiver
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MonitorAzureAppPushReceiver"/>. </summary>
        /// <param name="name"> The name of the Azure mobile app push receiver. Names must be unique across all receivers within an action group. </param>
        /// <param name="emailAddress"> The email address registered for the Azure mobile app. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="name"/> or <paramref name="emailAddress"/> is null. </exception>
        public MonitorAzureAppPushReceiver(string name, string emailAddress)
        {
            Argument.AssertNotNull(name, nameof(name));
            Argument.AssertNotNull(emailAddress, nameof(emailAddress));

            Name = name;
            EmailAddress = emailAddress;
        }

        /// <summary> Initializes a new instance of <see cref="MonitorAzureAppPushReceiver"/>. </summary>
        /// <param name="name"> The name of the Azure mobile app push receiver. Names must be unique across all receivers within an action group. </param>
        /// <param name="emailAddress"> The email address registered for the Azure mobile app. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MonitorAzureAppPushReceiver(string name, string emailAddress, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            EmailAddress = emailAddress;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="MonitorAzureAppPushReceiver"/> for deserialization. </summary>
        internal MonitorAzureAppPushReceiver()
        {
        }

        /// <summary> The name of the Azure mobile app push receiver. Names must be unique across all receivers within an action group. </summary>
        public string Name { get; set; }
        /// <summary> The email address registered for the Azure mobile app. </summary>
        public string EmailAddress { get; set; }
    }
}
