// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Monitor.Models
{
    /// <summary> An arm role receiver. </summary>
    public partial class MonitorArmRoleReceiver
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MonitorArmRoleReceiver"/>. </summary>
        /// <param name="name"> The name of the arm role receiver. Names must be unique across all receivers within an action group. </param>
        /// <param name="roleId"> The arm role id. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="name"/> or <paramref name="roleId"/> is null. </exception>
        public MonitorArmRoleReceiver(string name, string roleId)
        {
            Argument.AssertNotNull(name, nameof(name));
            Argument.AssertNotNull(roleId, nameof(roleId));

            Name = name;
            RoleId = roleId;
        }

        /// <summary> Initializes a new instance of <see cref="MonitorArmRoleReceiver"/>. </summary>
        /// <param name="name"> The name of the arm role receiver. Names must be unique across all receivers within an action group. </param>
        /// <param name="roleId"> The arm role id. </param>
        /// <param name="useCommonAlertSchema"> Indicates whether to use common alert schema. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MonitorArmRoleReceiver(string name, string roleId, bool? useCommonAlertSchema, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            RoleId = roleId;
            UseCommonAlertSchema = useCommonAlertSchema;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="MonitorArmRoleReceiver"/> for deserialization. </summary>
        internal MonitorArmRoleReceiver()
        {
        }

        /// <summary> The name of the arm role receiver. Names must be unique across all receivers within an action group. </summary>
        public string Name { get; set; }
        /// <summary> The arm role id. </summary>
        public string RoleId { get; set; }
        /// <summary> Indicates whether to use common alert schema. </summary>
        public bool? UseCommonAlertSchema { get; set; }
    }
}
