// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Monitor.Models
{
    internal static partial class MetricStatisticTypeExtensions
    {
        public static string ToSerialString(this MetricStatisticType value) => value switch
        {
            MetricStatisticType.Average => "Average",
            MetricStatisticType.Min => "Min",
            MetricStatisticType.Max => "Max",
            MetricStatisticType.Sum => "Sum",
            MetricStatisticType.Count => "Count",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown MetricStatisticType value.")
        };

        public static MetricStatisticType ToMetricStatisticType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Average")) return MetricStatisticType.Average;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Min")) return MetricStatisticType.Min;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Max")) return MetricStatisticType.Max;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Sum")) return MetricStatisticType.Sum;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Count")) return MetricStatisticType.Count;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown MetricStatisticType value.");
        }
    }
}
