// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Monitor.Models
{
    /// <summary> the criteria time aggregation types. </summary>
    public readonly partial struct MetricCriteriaTimeAggregationType : IEquatable<MetricCriteriaTimeAggregationType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MetricCriteriaTimeAggregationType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MetricCriteriaTimeAggregationType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AverageValue = "Average";
        private const string CountValue = "Count";
        private const string MinimumValue = "Minimum";
        private const string MaximumValue = "Maximum";
        private const string TotalValue = "Total";

        /// <summary> Average. </summary>
        public static MetricCriteriaTimeAggregationType Average { get; } = new MetricCriteriaTimeAggregationType(AverageValue);
        /// <summary> Count. </summary>
        public static MetricCriteriaTimeAggregationType Count { get; } = new MetricCriteriaTimeAggregationType(CountValue);
        /// <summary> Minimum. </summary>
        public static MetricCriteriaTimeAggregationType Minimum { get; } = new MetricCriteriaTimeAggregationType(MinimumValue);
        /// <summary> Maximum. </summary>
        public static MetricCriteriaTimeAggregationType Maximum { get; } = new MetricCriteriaTimeAggregationType(MaximumValue);
        /// <summary> Total. </summary>
        public static MetricCriteriaTimeAggregationType Total { get; } = new MetricCriteriaTimeAggregationType(TotalValue);
        /// <summary> Determines if two <see cref="MetricCriteriaTimeAggregationType"/> values are the same. </summary>
        public static bool operator ==(MetricCriteriaTimeAggregationType left, MetricCriteriaTimeAggregationType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MetricCriteriaTimeAggregationType"/> values are not the same. </summary>
        public static bool operator !=(MetricCriteriaTimeAggregationType left, MetricCriteriaTimeAggregationType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MetricCriteriaTimeAggregationType"/>. </summary>
        public static implicit operator MetricCriteriaTimeAggregationType(string value) => new MetricCriteriaTimeAggregationType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MetricCriteriaTimeAggregationType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MetricCriteriaTimeAggregationType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
