// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Monitor.Models
{
    /// <summary> An alert status properties. </summary>
    public partial class MetricAlertStatusProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MetricAlertStatusProperties"/>. </summary>
        internal MetricAlertStatusProperties()
        {
            Dimensions = new ChangeTrackingDictionary<string, string>();
        }

        /// <summary> Initializes a new instance of <see cref="MetricAlertStatusProperties"/>. </summary>
        /// <param name="dimensions"> An object describing the type of the dimensions. </param>
        /// <param name="status"> status value. </param>
        /// <param name="timestamp"> UTC time when the status was checked. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MetricAlertStatusProperties(IReadOnlyDictionary<string, string> dimensions, string status, DateTimeOffset? timestamp, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Dimensions = dimensions;
            Status = status;
            Timestamp = timestamp;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> An object describing the type of the dimensions. </summary>
        public IReadOnlyDictionary<string, string> Dimensions { get; }
        /// <summary> status value. </summary>
        public string Status { get; }
        /// <summary> UTC time when the status was checked. </summary>
        public DateTimeOffset? Timestamp { get; }
    }
}
