// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.Monitor.Models
{
    /// <summary> An alert action. </summary>
    public partial class MetricAlertAction
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="MetricAlertAction"/>. </summary>
        public MetricAlertAction()
        {
            WebHookProperties = new ChangeTrackingDictionary<string, string>();
        }

        /// <summary> Initializes a new instance of <see cref="MetricAlertAction"/>. </summary>
        /// <param name="actionGroupId"> the id of the action group to use. </param>
        /// <param name="webHookProperties"> This field allows specifying custom properties, which would be appended to the alert payload sent as input to the webhook. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal MetricAlertAction(ResourceIdentifier actionGroupId, IDictionary<string, string> webHookProperties, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ActionGroupId = actionGroupId;
            WebHookProperties = webHookProperties;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> the id of the action group to use. </summary>
        public ResourceIdentifier ActionGroupId { get; set; }
        /// <summary> This field allows specifying custom properties, which would be appended to the alert payload sent as input to the webhook. </summary>
        public IDictionary<string, string> WebHookProperties { get; }
    }
}
