// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Monitor.Models
{
    /// <summary> How the data that is collected should be combined over time. </summary>
    public partial class ManagementEventAggregationCondition
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ManagementEventAggregationCondition"/>. </summary>
        public ManagementEventAggregationCondition()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ManagementEventAggregationCondition"/>. </summary>
        /// <param name="operator"> the condition operator. </param>
        /// <param name="threshold"> The threshold value that activates the alert. </param>
        /// <param name="windowSize"> the period of time (in ISO 8601 duration format) that is used to monitor alert activity based on the threshold. If specified then it must be between 5 minutes and 1 day. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ManagementEventAggregationCondition(MonitorConditionOperator? @operator, double? threshold, TimeSpan? windowSize, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Operator = @operator;
            Threshold = threshold;
            WindowSize = windowSize;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> the condition operator. </summary>
        public MonitorConditionOperator? Operator { get; set; }
        /// <summary> The threshold value that activates the alert. </summary>
        public double? Threshold { get; set; }
        /// <summary> the period of time (in ISO 8601 duration format) that is used to monitor alert activity based on the threshold. If specified then it must be between 5 minutes and 1 day. </summary>
        public TimeSpan? WindowSize { get; set; }
    }
}
