// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.ResourceManager.Monitor.Models
{
    /// <summary> Definition of which custom log files will be collected by this data collection rule. </summary>
    public partial class LogFilesDataSource
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="LogFilesDataSource"/>. </summary>
        /// <param name="streams">
        /// List of streams that this data source will be sent to.
        /// A stream indicates what schema will be used for this data source
        /// </param>
        /// <param name="filePatterns"> File Patterns where the log files are located. </param>
        /// <param name="format"> The data format of the log files. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="streams"/> or <paramref name="filePatterns"/> is null. </exception>
        public LogFilesDataSource(IEnumerable<string> streams, IEnumerable<string> filePatterns, LogFilesDataSourceFormat format)
        {
            Argument.AssertNotNull(streams, nameof(streams));
            Argument.AssertNotNull(filePatterns, nameof(filePatterns));

            Streams = streams.ToList();
            FilePatterns = filePatterns.ToList();
            Format = format;
        }

        /// <summary> Initializes a new instance of <see cref="LogFilesDataSource"/>. </summary>
        /// <param name="streams">
        /// List of streams that this data source will be sent to.
        /// A stream indicates what schema will be used for this data source
        /// </param>
        /// <param name="filePatterns"> File Patterns where the log files are located. </param>
        /// <param name="format"> The data format of the log files. </param>
        /// <param name="settings"> The log files specific settings. </param>
        /// <param name="name">
        /// A friendly name for the data source.
        /// This name should be unique across all data sources (regardless of type) within the data collection rule.
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal LogFilesDataSource(IList<string> streams, IList<string> filePatterns, LogFilesDataSourceFormat format, LogFilesDataSourceSettings settings, string name, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Streams = streams;
            FilePatterns = filePatterns;
            Format = format;
            Settings = settings;
            Name = name;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="LogFilesDataSource"/> for deserialization. </summary>
        internal LogFilesDataSource()
        {
        }

        /// <summary>
        /// List of streams that this data source will be sent to.
        /// A stream indicates what schema will be used for this data source
        /// </summary>
        public IList<string> Streams { get; }
        /// <summary> File Patterns where the log files are located. </summary>
        public IList<string> FilePatterns { get; }
        /// <summary> The data format of the log files. </summary>
        public LogFilesDataSourceFormat Format { get; set; }
        /// <summary> The log files specific settings. </summary>
        internal LogFilesDataSourceSettings Settings { get; set; }
        /// <summary> One of the supported timestamp formats. </summary>
        public LogFileTextSettingsRecordStartTimestampFormat? TextRecordStartTimestampFormat
        {
            get => Settings is null ? default : Settings.TextRecordStartTimestampFormat;
            set
            {
                if (value.HasValue)
                {
                    if (Settings is null)
                        Settings = new LogFilesDataSourceSettings();
                    Settings.TextRecordStartTimestampFormat = value.Value;
                }
                else
                {
                    Settings = null;
                }
            }
        }

        /// <summary>
        /// A friendly name for the data source.
        /// This name should be unique across all data sources (regardless of type) within the data collection rule.
        /// </summary>
        public string Name { get; set; }
    }
}
