// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Monitor.Models
{
    /// <summary> Settings for text log files. </summary>
    internal partial class LogFileTextSettings
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private protected IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="LogFileTextSettings"/>. </summary>
        /// <param name="recordStartTimestampFormat"> One of the supported timestamp formats. </param>
        public LogFileTextSettings(LogFileTextSettingsRecordStartTimestampFormat recordStartTimestampFormat)
        {
            RecordStartTimestampFormat = recordStartTimestampFormat;
        }

        /// <summary> Initializes a new instance of <see cref="LogFileTextSettings"/>. </summary>
        /// <param name="recordStartTimestampFormat"> One of the supported timestamp formats. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal LogFileTextSettings(LogFileTextSettingsRecordStartTimestampFormat recordStartTimestampFormat, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            RecordStartTimestampFormat = recordStartTimestampFormat;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="LogFileTextSettings"/> for deserialization. </summary>
        internal LogFileTextSettings()
        {
        }

        /// <summary> One of the supported timestamp formats. </summary>
        public LogFileTextSettingsRecordStartTimestampFormat RecordStartTimestampFormat { get; set; }
    }
}
