// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Monitor.Models
{
    /// <summary> The ExtensionDataSourceStream. </summary>
    public readonly partial struct ExtensionDataSourceStream : IEquatable<ExtensionDataSourceStream>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ExtensionDataSourceStream"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ExtensionDataSourceStream(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string MicrosoftEventValue = "Microsoft-Event";
        private const string MicrosoftInsightsMetricsValue = "Microsoft-InsightsMetrics";
        private const string MicrosoftPerfValue = "Microsoft-Perf";
        private const string MicrosoftSyslogValue = "Microsoft-Syslog";
        private const string MicrosoftWindowsEventValue = "Microsoft-WindowsEvent";

        /// <summary> Microsoft-Event. </summary>
        public static ExtensionDataSourceStream MicrosoftEvent { get; } = new ExtensionDataSourceStream(MicrosoftEventValue);
        /// <summary> Microsoft-InsightsMetrics. </summary>
        public static ExtensionDataSourceStream MicrosoftInsightsMetrics { get; } = new ExtensionDataSourceStream(MicrosoftInsightsMetricsValue);
        /// <summary> Microsoft-Perf. </summary>
        public static ExtensionDataSourceStream MicrosoftPerf { get; } = new ExtensionDataSourceStream(MicrosoftPerfValue);
        /// <summary> Microsoft-Syslog. </summary>
        public static ExtensionDataSourceStream MicrosoftSyslog { get; } = new ExtensionDataSourceStream(MicrosoftSyslogValue);
        /// <summary> Microsoft-WindowsEvent. </summary>
        public static ExtensionDataSourceStream MicrosoftWindowsEvent { get; } = new ExtensionDataSourceStream(MicrosoftWindowsEventValue);
        /// <summary> Determines if two <see cref="ExtensionDataSourceStream"/> values are the same. </summary>
        public static bool operator ==(ExtensionDataSourceStream left, ExtensionDataSourceStream right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ExtensionDataSourceStream"/> values are not the same. </summary>
        public static bool operator !=(ExtensionDataSourceStream left, ExtensionDataSourceStream right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ExtensionDataSourceStream"/>. </summary>
        public static implicit operator ExtensionDataSourceStream(string value) => new ExtensionDataSourceStream(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ExtensionDataSourceStream other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ExtensionDataSourceStream other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
