// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Monitor.Models
{
    /// <summary> The extent of deviation required to trigger an alert. This will affect how tight the threshold is to the metric series pattern. </summary>
    public readonly partial struct DynamicThresholdSensitivity : IEquatable<DynamicThresholdSensitivity>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DynamicThresholdSensitivity"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DynamicThresholdSensitivity(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string LowValue = "Low";
        private const string MediumValue = "Medium";
        private const string HighValue = "High";

        /// <summary> Low. </summary>
        public static DynamicThresholdSensitivity Low { get; } = new DynamicThresholdSensitivity(LowValue);
        /// <summary> Medium. </summary>
        public static DynamicThresholdSensitivity Medium { get; } = new DynamicThresholdSensitivity(MediumValue);
        /// <summary> High. </summary>
        public static DynamicThresholdSensitivity High { get; } = new DynamicThresholdSensitivity(HighValue);
        /// <summary> Determines if two <see cref="DynamicThresholdSensitivity"/> values are the same. </summary>
        public static bool operator ==(DynamicThresholdSensitivity left, DynamicThresholdSensitivity right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DynamicThresholdSensitivity"/> values are not the same. </summary>
        public static bool operator !=(DynamicThresholdSensitivity left, DynamicThresholdSensitivity right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DynamicThresholdSensitivity"/>. </summary>
        public static implicit operator DynamicThresholdSensitivity(string value) => new DynamicThresholdSensitivity(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DynamicThresholdSensitivity other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DynamicThresholdSensitivity other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
