// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Monitor.Models
{
    /// <summary> The DataFlowStream. </summary>
    public readonly partial struct DataFlowStream : IEquatable<DataFlowStream>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataFlowStream"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataFlowStream(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string MicrosoftEventValue = "Microsoft-Event";
        private const string MicrosoftInsightsMetricsValue = "Microsoft-InsightsMetrics";
        private const string MicrosoftPerfValue = "Microsoft-Perf";
        private const string MicrosoftSyslogValue = "Microsoft-Syslog";
        private const string MicrosoftWindowsEventValue = "Microsoft-WindowsEvent";

        /// <summary> Microsoft-Event. </summary>
        public static DataFlowStream MicrosoftEvent { get; } = new DataFlowStream(MicrosoftEventValue);
        /// <summary> Microsoft-InsightsMetrics. </summary>
        public static DataFlowStream MicrosoftInsightsMetrics { get; } = new DataFlowStream(MicrosoftInsightsMetricsValue);
        /// <summary> Microsoft-Perf. </summary>
        public static DataFlowStream MicrosoftPerf { get; } = new DataFlowStream(MicrosoftPerfValue);
        /// <summary> Microsoft-Syslog. </summary>
        public static DataFlowStream MicrosoftSyslog { get; } = new DataFlowStream(MicrosoftSyslogValue);
        /// <summary> Microsoft-WindowsEvent. </summary>
        public static DataFlowStream MicrosoftWindowsEvent { get; } = new DataFlowStream(MicrosoftWindowsEventValue);
        /// <summary> Determines if two <see cref="DataFlowStream"/> values are the same. </summary>
        public static bool operator ==(DataFlowStream left, DataFlowStream right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataFlowStream"/> values are not the same. </summary>
        public static bool operator !=(DataFlowStream left, DataFlowStream right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataFlowStream"/>. </summary>
        public static implicit operator DataFlowStream(string value) => new DataFlowStream(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataFlowStream other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataFlowStream other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
