// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Monitor.Models
{
    /// <summary> The kind of the resource. </summary>
    public readonly partial struct DataCollectionRuleResourceKind : IEquatable<DataCollectionRuleResourceKind>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataCollectionRuleResourceKind"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataCollectionRuleResourceKind(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string LinuxValue = "Linux";
        private const string WindowsValue = "Windows";

        /// <summary> Linux. </summary>
        public static DataCollectionRuleResourceKind Linux { get; } = new DataCollectionRuleResourceKind(LinuxValue);
        /// <summary> Windows. </summary>
        public static DataCollectionRuleResourceKind Windows { get; } = new DataCollectionRuleResourceKind(WindowsValue);
        /// <summary> Determines if two <see cref="DataCollectionRuleResourceKind"/> values are the same. </summary>
        public static bool operator ==(DataCollectionRuleResourceKind left, DataCollectionRuleResourceKind right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataCollectionRuleResourceKind"/> values are not the same. </summary>
        public static bool operator !=(DataCollectionRuleResourceKind left, DataCollectionRuleResourceKind right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataCollectionRuleResourceKind"/>. </summary>
        public static implicit operator DataCollectionRuleResourceKind(string value) => new DataCollectionRuleResourceKind(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataCollectionRuleResourceKind other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataCollectionRuleResourceKind other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
