// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Monitor.Models
{
    /// <summary> The resource provisioning state. </summary>
    public readonly partial struct DataCollectionRuleProvisioningState : IEquatable<DataCollectionRuleProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataCollectionRuleProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataCollectionRuleProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CreatingValue = "Creating";
        private const string UpdatingValue = "Updating";
        private const string DeletingValue = "Deleting";
        private const string SucceededValue = "Succeeded";
        private const string CanceledValue = "Canceled";
        private const string FailedValue = "Failed";

        /// <summary> Creating. </summary>
        public static DataCollectionRuleProvisioningState Creating { get; } = new DataCollectionRuleProvisioningState(CreatingValue);
        /// <summary> Updating. </summary>
        public static DataCollectionRuleProvisioningState Updating { get; } = new DataCollectionRuleProvisioningState(UpdatingValue);
        /// <summary> Deleting. </summary>
        public static DataCollectionRuleProvisioningState Deleting { get; } = new DataCollectionRuleProvisioningState(DeletingValue);
        /// <summary> Succeeded. </summary>
        public static DataCollectionRuleProvisioningState Succeeded { get; } = new DataCollectionRuleProvisioningState(SucceededValue);
        /// <summary> Canceled. </summary>
        public static DataCollectionRuleProvisioningState Canceled { get; } = new DataCollectionRuleProvisioningState(CanceledValue);
        /// <summary> Failed. </summary>
        public static DataCollectionRuleProvisioningState Failed { get; } = new DataCollectionRuleProvisioningState(FailedValue);
        /// <summary> Determines if two <see cref="DataCollectionRuleProvisioningState"/> values are the same. </summary>
        public static bool operator ==(DataCollectionRuleProvisioningState left, DataCollectionRuleProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataCollectionRuleProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(DataCollectionRuleProvisioningState left, DataCollectionRuleProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataCollectionRuleProvisioningState"/>. </summary>
        public static implicit operator DataCollectionRuleProvisioningState(string value) => new DataCollectionRuleProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataCollectionRuleProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataCollectionRuleProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
