// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Monitor.Models
{
    /// <summary>
    /// The specification of data sources.
    /// This property is optional and can be omitted if the rule is meant to be used via direct calls to the provisioned endpoint.
    /// </summary>
    public partial class DataCollectionRuleDataSources : DataSourcesSpec
    {
        /// <summary> Initializes a new instance of <see cref="DataCollectionRuleDataSources"/>. </summary>
        public DataCollectionRuleDataSources()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DataCollectionRuleDataSources"/>. </summary>
        /// <param name="performanceCounters"> The list of performance counter data source configurations. </param>
        /// <param name="windowsEventLogs"> The list of Windows Event Log data source configurations. </param>
        /// <param name="syslog"> The list of Syslog data source configurations. </param>
        /// <param name="extensions"> The list of Azure VM extension data source configurations. </param>
        /// <param name="logFiles"> The list of Log files source configurations. </param>
        /// <param name="iisLogs"> The list of IIS logs source configurations. </param>
        /// <param name="windowsFirewallLogs"> The list of Windows Firewall logs source configurations. </param>
        /// <param name="prometheusForwarder"> The list of Prometheus forwarder data source configurations. </param>
        /// <param name="platformTelemetry"> The list of platform telemetry configurations. </param>
        /// <param name="dataImports"> Specifications of pull based data sources. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DataCollectionRuleDataSources(IList<PerfCounterDataSource> performanceCounters, IList<WindowsEventLogDataSource> windowsEventLogs, IList<SyslogDataSource> syslog, IList<ExtensionDataSource> extensions, IList<LogFilesDataSource> logFiles, IList<IisLogsDataSource> iisLogs, IList<WindowsFirewallLogsDataSource> windowsFirewallLogs, IList<PrometheusForwarderDataSource> prometheusForwarder, IList<PlatformTelemetryDataSource> platformTelemetry, DataSourcesSpecDataImports dataImports, IDictionary<string, BinaryData> serializedAdditionalRawData) : base(performanceCounters, windowsEventLogs, syslog, extensions, logFiles, iisLogs, windowsFirewallLogs, prometheusForwarder, platformTelemetry, dataImports, serializedAdditionalRawData)
        {
        }
    }
}
