// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Monitor.Models
{
    /// <summary> The resource provisioning state in this location. </summary>
    public readonly partial struct DataCollectionRuleBcdrLocationSpecProvisioningStatus : IEquatable<DataCollectionRuleBcdrLocationSpecProvisioningStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataCollectionRuleBcdrLocationSpecProvisioningStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataCollectionRuleBcdrLocationSpecProvisioningStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CreatingValue = "Creating";
        private const string UpdatingValue = "Updating";
        private const string DeletingValue = "Deleting";
        private const string SucceededValue = "Succeeded";
        private const string CanceledValue = "Canceled";
        private const string FailedValue = "Failed";

        /// <summary> Creating. </summary>
        public static DataCollectionRuleBcdrLocationSpecProvisioningStatus Creating { get; } = new DataCollectionRuleBcdrLocationSpecProvisioningStatus(CreatingValue);
        /// <summary> Updating. </summary>
        public static DataCollectionRuleBcdrLocationSpecProvisioningStatus Updating { get; } = new DataCollectionRuleBcdrLocationSpecProvisioningStatus(UpdatingValue);
        /// <summary> Deleting. </summary>
        public static DataCollectionRuleBcdrLocationSpecProvisioningStatus Deleting { get; } = new DataCollectionRuleBcdrLocationSpecProvisioningStatus(DeletingValue);
        /// <summary> Succeeded. </summary>
        public static DataCollectionRuleBcdrLocationSpecProvisioningStatus Succeeded { get; } = new DataCollectionRuleBcdrLocationSpecProvisioningStatus(SucceededValue);
        /// <summary> Canceled. </summary>
        public static DataCollectionRuleBcdrLocationSpecProvisioningStatus Canceled { get; } = new DataCollectionRuleBcdrLocationSpecProvisioningStatus(CanceledValue);
        /// <summary> Failed. </summary>
        public static DataCollectionRuleBcdrLocationSpecProvisioningStatus Failed { get; } = new DataCollectionRuleBcdrLocationSpecProvisioningStatus(FailedValue);
        /// <summary> Determines if two <see cref="DataCollectionRuleBcdrLocationSpecProvisioningStatus"/> values are the same. </summary>
        public static bool operator ==(DataCollectionRuleBcdrLocationSpecProvisioningStatus left, DataCollectionRuleBcdrLocationSpecProvisioningStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataCollectionRuleBcdrLocationSpecProvisioningStatus"/> values are not the same. </summary>
        public static bool operator !=(DataCollectionRuleBcdrLocationSpecProvisioningStatus left, DataCollectionRuleBcdrLocationSpecProvisioningStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataCollectionRuleBcdrLocationSpecProvisioningStatus"/>. </summary>
        public static implicit operator DataCollectionRuleBcdrLocationSpecProvisioningStatus(string value) => new DataCollectionRuleBcdrLocationSpecProvisioningStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataCollectionRuleBcdrLocationSpecProvisioningStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataCollectionRuleBcdrLocationSpecProvisioningStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
