// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.Monitor.Models
{
    /// <summary> The DataCollectionRuleBcdrLocationSpec. </summary>
    public partial class DataCollectionRuleBcdrLocationSpec
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="DataCollectionRuleBcdrLocationSpec"/>. </summary>
        internal DataCollectionRuleBcdrLocationSpec()
        {
        }

        /// <summary> Initializes a new instance of <see cref="DataCollectionRuleBcdrLocationSpec"/>. </summary>
        /// <param name="location"> Name of location. </param>
        /// <param name="provisioningStatus"> The resource provisioning state in this location. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal DataCollectionRuleBcdrLocationSpec(AzureLocation? location, DataCollectionRuleBcdrLocationSpecProvisioningStatus? provisioningStatus, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Location = location;
            ProvisioningStatus = provisioningStatus;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Name of location. </summary>
        public AzureLocation? Location { get; }
        /// <summary> The resource provisioning state in this location. </summary>
        public DataCollectionRuleBcdrLocationSpecProvisioningStatus? ProvisioningStatus { get; }
    }
}
