// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Monitor.Models
{
    /// <summary> The resource provisioning state. </summary>
    public readonly partial struct DataCollectionRuleAssociationProvisioningState : IEquatable<DataCollectionRuleAssociationProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="DataCollectionRuleAssociationProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public DataCollectionRuleAssociationProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string CreatingValue = "Creating";
        private const string UpdatingValue = "Updating";
        private const string DeletingValue = "Deleting";
        private const string SucceededValue = "Succeeded";
        private const string CanceledValue = "Canceled";
        private const string FailedValue = "Failed";

        /// <summary> Creating. </summary>
        public static DataCollectionRuleAssociationProvisioningState Creating { get; } = new DataCollectionRuleAssociationProvisioningState(CreatingValue);
        /// <summary> Updating. </summary>
        public static DataCollectionRuleAssociationProvisioningState Updating { get; } = new DataCollectionRuleAssociationProvisioningState(UpdatingValue);
        /// <summary> Deleting. </summary>
        public static DataCollectionRuleAssociationProvisioningState Deleting { get; } = new DataCollectionRuleAssociationProvisioningState(DeletingValue);
        /// <summary> Succeeded. </summary>
        public static DataCollectionRuleAssociationProvisioningState Succeeded { get; } = new DataCollectionRuleAssociationProvisioningState(SucceededValue);
        /// <summary> Canceled. </summary>
        public static DataCollectionRuleAssociationProvisioningState Canceled { get; } = new DataCollectionRuleAssociationProvisioningState(CanceledValue);
        /// <summary> Failed. </summary>
        public static DataCollectionRuleAssociationProvisioningState Failed { get; } = new DataCollectionRuleAssociationProvisioningState(FailedValue);
        /// <summary> Determines if two <see cref="DataCollectionRuleAssociationProvisioningState"/> values are the same. </summary>
        public static bool operator ==(DataCollectionRuleAssociationProvisioningState left, DataCollectionRuleAssociationProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="DataCollectionRuleAssociationProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(DataCollectionRuleAssociationProvisioningState left, DataCollectionRuleAssociationProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="DataCollectionRuleAssociationProvisioningState"/>. </summary>
        public static implicit operator DataCollectionRuleAssociationProvisioningState(string value) => new DataCollectionRuleAssociationProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is DataCollectionRuleAssociationProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(DataCollectionRuleAssociationProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
