// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.Monitor.Models
{
    /// <summary> The autoscale setting object for patch operations. </summary>
    public partial class AutoscaleSettingPatch
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AutoscaleSettingPatch"/>. </summary>
        public AutoscaleSettingPatch()
        {
            Tags = new ChangeTrackingDictionary<string, string>();
            Profiles = new ChangeTrackingList<AutoscaleProfile>();
            Notifications = new ChangeTrackingList<AutoscaleNotification>();
        }

        /// <summary> Initializes a new instance of <see cref="AutoscaleSettingPatch"/>. </summary>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="profiles"> the collection of automatic scaling profiles that specify different scaling parameters for different time periods. A maximum of 20 profiles can be specified. </param>
        /// <param name="notifications"> the collection of notifications. </param>
        /// <param name="isEnabled"> the enabled flag. Specifies whether automatic scaling is enabled for the resource. The default value is 'false'. </param>
        /// <param name="predictiveAutoscalePolicy"> the predictive autoscale policy mode. </param>
        /// <param name="autoscaleSettingName"> the name of the autoscale setting. </param>
        /// <param name="targetResourceId"> the resource identifier of the resource that the autoscale setting should be added to. </param>
        /// <param name="targetResourceLocation"> the location of the resource that the autoscale setting should be added to. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AutoscaleSettingPatch(IDictionary<string, string> tags, IList<AutoscaleProfile> profiles, IList<AutoscaleNotification> notifications, bool? isEnabled, PredictiveAutoscalePolicy predictiveAutoscalePolicy, string autoscaleSettingName, ResourceIdentifier targetResourceId, AzureLocation? targetResourceLocation, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Tags = tags;
            Profiles = profiles;
            Notifications = notifications;
            IsEnabled = isEnabled;
            PredictiveAutoscalePolicy = predictiveAutoscalePolicy;
            AutoscaleSettingName = autoscaleSettingName;
            TargetResourceId = targetResourceId;
            TargetResourceLocation = targetResourceLocation;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Resource tags. </summary>
        public IDictionary<string, string> Tags { get; }
        /// <summary> the collection of automatic scaling profiles that specify different scaling parameters for different time periods. A maximum of 20 profiles can be specified. </summary>
        public IList<AutoscaleProfile> Profiles { get; }
        /// <summary> the collection of notifications. </summary>
        public IList<AutoscaleNotification> Notifications { get; set; }
        /// <summary> the enabled flag. Specifies whether automatic scaling is enabled for the resource. The default value is 'false'. </summary>
        public bool? IsEnabled { get; set; }
        /// <summary> the predictive autoscale policy mode. </summary>
        public PredictiveAutoscalePolicy PredictiveAutoscalePolicy { get; set; }
        /// <summary> the name of the autoscale setting. </summary>
        public string AutoscaleSettingName { get; set; }
        /// <summary> the resource identifier of the resource that the autoscale setting should be added to. </summary>
        public ResourceIdentifier TargetResourceId { get; set; }
        /// <summary> the location of the resource that the autoscale setting should be added to. </summary>
        public AzureLocation? TargetResourceLocation { get; set; }
    }
}
