// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Monitor.Models
{
    /// <summary> Autoscale notification. </summary>
    public partial class AutoscaleNotification
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AutoscaleNotification"/>. </summary>
        public AutoscaleNotification()
        {
            Operation = MonitorOperationType.Scale;
            Webhooks = new ChangeTrackingList<WebhookNotification>();
        }

        /// <summary> Initializes a new instance of <see cref="AutoscaleNotification"/>. </summary>
        /// <param name="operation"> the operation associated with the notification and its value must be "scale". </param>
        /// <param name="email"> the email notification. </param>
        /// <param name="webhooks"> the collection of webhook notifications. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AutoscaleNotification(MonitorOperationType operation, EmailNotification email, IList<WebhookNotification> webhooks, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Operation = operation;
            Email = email;
            Webhooks = webhooks;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }
        /// <summary> the email notification. </summary>
        public EmailNotification Email { get; set; }
        /// <summary> the collection of webhook notifications. </summary>
        public IList<WebhookNotification> Webhooks { get; }
    }
}
