// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.ResourceManager.Monitor.Models
{
    /// <summary> The ArmResourceGetMonitorMetricBaselinesOptions. </summary>
    public partial class ArmResourceGetMonitorMetricBaselinesOptions
    {
        /// <summary> Initializes a new instance of <see cref="ArmResourceGetMonitorMetricBaselinesOptions"/>. </summary>
        public ArmResourceGetMonitorMetricBaselinesOptions()
        {
        }

        /// <summary> The names of the metrics (comma separated) to retrieve. Special case: If a metricname itself has a comma in it then use %2 to indicate it. Eg: 'Metric,Name1' should be **'Metric%2Name1'**. </summary>
        public string Metricnames { get; set; }
        /// <summary> Metric namespace to query metric definitions for. </summary>
        public string Metricnamespace { get; set; }
        /// <summary> The timespan of the query. It is a string with the following format 'startDateTime_ISO/endDateTime_ISO'. </summary>
        public string Timespan { get; set; }
        /// <summary> The interval (i.e. timegrain) of the query. </summary>
        public TimeSpan? Interval { get; set; }
        /// <summary> The list of aggregation types (comma separated) to retrieve. </summary>
        public string Aggregation { get; set; }
        /// <summary> The list of sensitivities (comma separated) to retrieve. </summary>
        public string Sensitivities { get; set; }
        /// <summary> The **$filter** is used to reduce the set of metric data returned. Example: Metric contains metadata A, B and C. - Return all time series of C where A = a1 and B = b1 or b2 **$filter=A eq 'a1' and B eq 'b1' or B eq 'b2' and C eq '*'** - Invalid variant: **$filter=A eq 'a1' and B eq 'b1' and C eq '*' or B = 'b2'** This is invalid because the logical or operator cannot separate two different metadata names. - Return all time series where A = a1, B = b1 and C = c1: **$filter=A eq 'a1' and B eq 'b1' and C eq 'c1'** - Return all time series where A = a1 **$filter=A eq 'a1' and B eq '*' and C eq '*'**. Special case: When dimension name or dimension value uses round brackets. Eg: When dimension name is **dim (test) 1** Instead of using $filter= "dim (test) 1 eq '*' " use **$filter= "dim %2528test%2529 1 eq '*' "** When dimension name is **dim (test) 3** and dimension value is **dim3 (test) val** Instead of using $filter= "dim (test) 3 eq 'dim3 (test) val' " use **$filter= "dim %2528test%2529 3 eq 'dim3 %2528test%2529 val' "**. </summary>
        public string Filter { get; set; }
        /// <summary> Allows retrieving only metadata of the baseline. On data request all information is retrieved. </summary>
        public MonitorResultType? ResultType { get; set; }
    }
}
