// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;
using System.Globalization;

namespace Azure.ResourceManager.Monitor.Models
{
    /// <summary> Severity of the alert. Should be an integer between [0-4]. Value of 0 is severest. Relevant and required only for rules of the kind LogAlert. </summary>
    public readonly partial struct AlertSeverity : IEquatable<AlertSeverity>
    {
        private readonly long _value;

        /// <summary> Initializes a new instance of <see cref="AlertSeverity"/>. </summary>
        public AlertSeverity(long value)
        {
            _value = value;
        }

        private const long ZeroValue = 0L;
        private const long OneValue = 1L;
        private const long TwoValue = 2L;
        private const long ThreeValue = 3L;
        private const long FourValue = 4L;

        /// <summary> 0. </summary>
        public static AlertSeverity Zero { get; } = new AlertSeverity(ZeroValue);
        /// <summary> 1. </summary>
        public static AlertSeverity One { get; } = new AlertSeverity(OneValue);
        /// <summary> 2. </summary>
        public static AlertSeverity Two { get; } = new AlertSeverity(TwoValue);
        /// <summary> 3. </summary>
        public static AlertSeverity Three { get; } = new AlertSeverity(ThreeValue);
        /// <summary> 4. </summary>
        public static AlertSeverity Four { get; } = new AlertSeverity(FourValue);

        internal long ToSerialInt64() => _value;

        /// <summary> Determines if two <see cref="AlertSeverity"/> values are the same. </summary>
        public static bool operator ==(AlertSeverity left, AlertSeverity right) => left.Equals(right);
        /// <summary> Determines if two <see cref="AlertSeverity"/> values are not the same. </summary>
        public static bool operator !=(AlertSeverity left, AlertSeverity right) => !left.Equals(right);
        /// <summary> Converts a <see cref="long"/> to a <see cref="AlertSeverity"/>. </summary>
        public static implicit operator AlertSeverity(long value) => new AlertSeverity(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is AlertSeverity other && Equals(other);
        /// <inheritdoc />
        public bool Equals(AlertSeverity other) => Equals(_value, other._value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value.GetHashCode();
        /// <inheritdoc />
        public override string ToString() => _value.ToString(CultureInfo.InvariantCulture);
    }
}
