// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Monitor.Models
{
    /// <summary>
    /// An Activity Log Alert rule condition that is met by comparing the field and value of an Activity Log event.
    /// This condition must contain 'field' and either 'equals' or 'containsAny'.
    /// </summary>
    public partial class AlertRuleLeafCondition
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private protected IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AlertRuleLeafCondition"/>. </summary>
        public AlertRuleLeafCondition()
        {
            ContainsAny = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="AlertRuleLeafCondition"/>. </summary>
        /// <param name="field">
        /// The name of the Activity Log event's field that this condition will examine.
        /// The possible values for this field are (case-insensitive): 'resourceId', 'category', 'caller', 'level', 'operationName', 'resourceGroup', 'resourceProvider', 'status', 'subStatus', 'resourceType', or anything beginning with 'properties'.
        /// </param>
        /// <param name="equalsValue"> The value of the event's field will be compared to this value (case-insensitive) to determine if the condition is met. </param>
        /// <param name="containsAny"> The value of the event's field will be compared to the values in this array (case-insensitive) to determine if the condition is met. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AlertRuleLeafCondition(string field, string equalsValue, IList<string> containsAny, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Field = field;
            EqualsValue = equalsValue;
            ContainsAny = containsAny;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary>
        /// The name of the Activity Log event's field that this condition will examine.
        /// The possible values for this field are (case-insensitive): 'resourceId', 'category', 'caller', 'level', 'operationName', 'resourceGroup', 'resourceProvider', 'status', 'subStatus', 'resourceType', or anything beginning with 'properties'.
        /// </summary>
        public string Field { get; set; }
        /// <summary> The value of the event's field will be compared to this value (case-insensitive) to determine if the condition is met. </summary>
        public string EqualsValue { get; set; }
        /// <summary> The value of the event's field will be compared to the values in this array (case-insensitive) to determine if the condition is met. </summary>
        public IList<string> ContainsAny { get; }
    }
}
