// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.ResourceManager.Monitor.Models;

namespace Azure.ResourceManager.Monitor
{
    internal class NotificationStatusOperationSource : IOperationSource<NotificationStatus>
    {
        NotificationStatus IOperationSource<NotificationStatus>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            return NotificationStatus.DeserializeNotificationStatus(document.RootElement);
        }

        async ValueTask<NotificationStatus> IOperationSource<NotificationStatus>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            return NotificationStatus.DeserializeNotificationStatus(document.RootElement);
        }
    }
}
