// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Monitor
{
    internal class MonitorWorkspaceResourceOperationSource : IOperationSource<MonitorWorkspaceResource>
    {
        private readonly ArmClient _client;

        internal MonitorWorkspaceResourceOperationSource(ArmClient client)
        {
            _client = client;
        }

        MonitorWorkspaceResource IOperationSource<MonitorWorkspaceResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = MonitorWorkspaceResourceData.DeserializeMonitorWorkspaceResourceData(document.RootElement);
            return new MonitorWorkspaceResource(_client, data);
        }

        async ValueTask<MonitorWorkspaceResource> IOperationSource<MonitorWorkspaceResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = MonitorWorkspaceResourceData.DeserializeMonitorWorkspaceResourceData(document.RootElement);
            return new MonitorWorkspaceResource(_client, data);
        }
    }
}
