// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Monitor
{
    internal class MonitorPrivateEndpointConnectionOperationSource : IOperationSource<MonitorPrivateEndpointConnectionResource>
    {
        private readonly ArmClient _client;

        internal MonitorPrivateEndpointConnectionOperationSource(ArmClient client)
        {
            _client = client;
        }

        MonitorPrivateEndpointConnectionResource IOperationSource<MonitorPrivateEndpointConnectionResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = MonitorPrivateEndpointConnectionData.DeserializeMonitorPrivateEndpointConnectionData(document.RootElement);
            return new MonitorPrivateEndpointConnectionResource(_client, data);
        }

        async ValueTask<MonitorPrivateEndpointConnectionResource> IOperationSource<MonitorPrivateEndpointConnectionResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = MonitorPrivateEndpointConnectionData.DeserializeMonitorPrivateEndpointConnectionData(document.RootElement);
            return new MonitorPrivateEndpointConnectionResource(_client, data);
        }
    }
}
