// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Linq;
using System.Net;
using Azure.Core;
using Azure.ResourceManager.Models;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.Monitor.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class ArmMonitorModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="Monitor.AutoscaleSettingData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="profiles"> the collection of automatic scaling profiles that specify different scaling parameters for different time periods. A maximum of 20 profiles can be specified. </param>
        /// <param name="notifications"> the collection of notifications. </param>
        /// <param name="isEnabled"> the enabled flag. Specifies whether automatic scaling is enabled for the resource. The default value is 'false'. </param>
        /// <param name="predictiveAutoscalePolicy"> the predictive autoscale policy mode. </param>
        /// <param name="autoscaleSettingName"> the name of the autoscale setting. </param>
        /// <param name="targetResourceId"> the resource identifier of the resource that the autoscale setting should be added to. </param>
        /// <param name="targetResourceLocation"> the location of the resource that the autoscale setting should be added to. </param>
        /// <returns> A new <see cref="Monitor.AutoscaleSettingData"/> instance for mocking. </returns>
        public static AutoscaleSettingData AutoscaleSettingData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, IEnumerable<AutoscaleProfile> profiles = null, IEnumerable<AutoscaleNotification> notifications = null, bool? isEnabled = null, PredictiveAutoscalePolicy predictiveAutoscalePolicy = null, string autoscaleSettingName = null, ResourceIdentifier targetResourceId = null, AzureLocation? targetResourceLocation = null)
        {
            tags ??= new Dictionary<string, string>();
            profiles ??= new List<AutoscaleProfile>();
            notifications ??= new List<AutoscaleNotification>();

            return new AutoscaleSettingData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                profiles?.ToList(),
                notifications?.ToList(),
                isEnabled,
                predictiveAutoscalePolicy,
                autoscaleSettingName,
                targetResourceId,
                targetResourceLocation,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AutoscaleNotification"/>. </summary>
        /// <param name="operation"> the operation associated with the notification and its value must be "scale". </param>
        /// <param name="email"> the email notification. </param>
        /// <param name="webhooks"> the collection of webhook notifications. </param>
        /// <returns> A new <see cref="Models.AutoscaleNotification"/> instance for mocking. </returns>
        public static AutoscaleNotification AutoscaleNotification(MonitorOperationType operation = default, EmailNotification email = null, IEnumerable<WebhookNotification> webhooks = null)
        {
            webhooks ??= new List<WebhookNotification>();

            return new AutoscaleNotification(operation, email, webhooks?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AutoscaleSettingPredicativeResult"/>. </summary>
        /// <param name="timespan"> The timespan for which the data was retrieved. Its value consists of two datetimes concatenated, separated by '/'.  This may be adjusted in the future and returned back from what was originally requested. </param>
        /// <param name="interval"> The interval (window size) for which the metric data was returned in.  This may be adjusted in the future and returned back from what was originally requested.  This is not present if a metadata request was made. </param>
        /// <param name="metricName"> The metrics being queried. </param>
        /// <param name="targetResourceId"> resource of the predictive metric. </param>
        /// <param name="data"> the value of the collection. </param>
        /// <returns> A new <see cref="Models.AutoscaleSettingPredicativeResult"/> instance for mocking. </returns>
        public static AutoscaleSettingPredicativeResult AutoscaleSettingPredicativeResult(string timespan = null, TimeSpan? interval = null, string metricName = null, ResourceIdentifier targetResourceId = null, IEnumerable<PredictiveValue> data = null)
        {
            data ??= new List<PredictiveValue>();

            return new AutoscaleSettingPredicativeResult(
                timespan,
                interval,
                metricName,
                targetResourceId,
                data?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.PredictiveValue"/>. </summary>
        /// <param name="timeStamp"> the timestamp for the metric value in ISO 8601 format. </param>
        /// <param name="value"> Predictive value in this time bucket. </param>
        /// <returns> A new <see cref="Models.PredictiveValue"/> instance for mocking. </returns>
        public static PredictiveValue PredictiveValue(DateTimeOffset timeStamp = default, double value = default)
        {
            return new PredictiveValue(timeStamp, value, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MonitorIncident"/>. </summary>
        /// <param name="name"> Incident name. </param>
        /// <param name="ruleName"> Rule name that is associated with the incident. </param>
        /// <param name="isActive"> A boolean to indicate whether the incident is active or resolved. </param>
        /// <param name="activatedOn"> The time at which the incident was activated in ISO8601 format. </param>
        /// <param name="resolvedOn"> The time at which the incident was resolved in ISO8601 format. If null, it means the incident is still active. </param>
        /// <returns> A new <see cref="Models.MonitorIncident"/> instance for mocking. </returns>
        public static MonitorIncident MonitorIncident(string name = null, string ruleName = null, bool? isActive = null, DateTimeOffset? activatedOn = null, DateTimeOffset? resolvedOn = null)
        {
            return new MonitorIncident(
                name,
                ruleName,
                isActive,
                activatedOn,
                resolvedOn,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Monitor.AlertRuleData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="alertRuleName"> the name of the alert rule. </param>
        /// <param name="description"> the description of the alert rule that will be included in the alert email. </param>
        /// <param name="provisioningState"> the provisioning state. </param>
        /// <param name="isEnabled"> the flag that indicates whether the alert rule is enabled. </param>
        /// <param name="condition">
        /// the condition that results in the alert rule being activated.
        /// Please note <see cref="AlertRuleCondition"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="LocationThresholdRuleCondition"/>, <see cref="ManagementEventRuleCondition"/> and <see cref="ThresholdRuleCondition"/>.
        /// </param>
        /// <param name="action">
        /// action that is performed when the alert rule becomes active, and when an alert condition is resolved.
        /// Please note <see cref="AlertRuleAction"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="RuleEmailAction"/> and <see cref="RuleWebhookAction"/>.
        /// </param>
        /// <param name="actions">
        /// the array of actions that are performed when the alert rule becomes active, and when an alert condition is resolved.
        /// Please note <see cref="AlertRuleAction"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="RuleEmailAction"/> and <see cref="RuleWebhookAction"/>.
        /// </param>
        /// <param name="lastUpdatedOn"> Last time the rule was updated in ISO8601 format. </param>
        /// <returns> A new <see cref="Monitor.AlertRuleData"/> instance for mocking. </returns>
        public static AlertRuleData AlertRuleData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, string alertRuleName = null, string description = null, string provisioningState = null, bool isEnabled = default, AlertRuleCondition condition = null, AlertRuleAction action = null, IEnumerable<AlertRuleAction> actions = null, DateTimeOffset? lastUpdatedOn = null)
        {
            tags ??= new Dictionary<string, string>();
            actions ??= new List<AlertRuleAction>();

            return new AlertRuleData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                alertRuleName,
                description,
                provisioningState,
                isEnabled,
                condition,
                action,
                actions?.ToList(),
                lastUpdatedOn,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.AlertRulePatch"/>. </summary>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="name"> the name of the alert rule. </param>
        /// <param name="description"> the description of the alert rule that will be included in the alert email. </param>
        /// <param name="provisioningState"> the provisioning state. </param>
        /// <param name="isEnabled"> the flag that indicates whether the alert rule is enabled. </param>
        /// <param name="condition">
        /// the condition that results in the alert rule being activated.
        /// Please note <see cref="AlertRuleCondition"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="LocationThresholdRuleCondition"/>, <see cref="ManagementEventRuleCondition"/> and <see cref="ThresholdRuleCondition"/>.
        /// </param>
        /// <param name="action">
        /// action that is performed when the alert rule becomes active, and when an alert condition is resolved.
        /// Please note <see cref="AlertRuleAction"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="RuleEmailAction"/> and <see cref="RuleWebhookAction"/>.
        /// </param>
        /// <param name="actions">
        /// the array of actions that are performed when the alert rule becomes active, and when an alert condition is resolved.
        /// Please note <see cref="AlertRuleAction"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="RuleEmailAction"/> and <see cref="RuleWebhookAction"/>.
        /// </param>
        /// <param name="lastUpdatedOn"> Last time the rule was updated in ISO8601 format. </param>
        /// <returns> A new <see cref="Models.AlertRulePatch"/> instance for mocking. </returns>
        public static AlertRulePatch AlertRulePatch(IDictionary<string, string> tags = null, string name = null, string description = null, string provisioningState = null, bool? isEnabled = null, AlertRuleCondition condition = null, AlertRuleAction action = null, IEnumerable<AlertRuleAction> actions = null, DateTimeOffset? lastUpdatedOn = null)
        {
            tags ??= new Dictionary<string, string>();
            actions ??= new List<AlertRuleAction>();

            return new AlertRulePatch(
                tags,
                name,
                description,
                provisioningState,
                isEnabled,
                condition,
                action,
                actions?.ToList(),
                lastUpdatedOn,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Monitor.LogProfileData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="storageAccountId"> the resource id of the storage account to which you would like to send the Activity Log. </param>
        /// <param name="serviceBusRuleId"> The service bus rule ID of the service bus namespace in which you would like to have Event Hubs created for streaming the Activity Log. The rule ID is of the format: '{service bus resource ID}/authorizationrules/{key name}'. </param>
        /// <param name="locations"> List of regions for which Activity Log events should be stored or streamed. It is a comma separated list of valid ARM locations including the 'global' location. </param>
        /// <param name="categories"> the categories of the logs. These categories are created as is convenient to the user. Some values are: 'Write', 'Delete', and/or 'Action.'. </param>
        /// <param name="retentionPolicy"> the retention policy for the events in the log. </param>
        /// <returns> A new <see cref="Monitor.LogProfileData"/> instance for mocking. </returns>
        public static LogProfileData LogProfileData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, ResourceIdentifier storageAccountId = null, ResourceIdentifier serviceBusRuleId = null, IEnumerable<AzureLocation> locations = null, IEnumerable<string> categories = null, RetentionPolicy retentionPolicy = null)
        {
            tags ??= new Dictionary<string, string>();
            locations ??= new List<AzureLocation>();
            categories ??= new List<string>();

            return new LogProfileData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                storageAccountId,
                serviceBusRuleId,
                locations?.ToList(),
                categories?.ToList(),
                retentionPolicy,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Monitor.DiagnosticSettingData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="storageAccountId"> The resource ID of the storage account to which you would like to send Diagnostic Logs. </param>
        /// <param name="serviceBusRuleId"> The service bus rule Id of the diagnostic setting. This is here to maintain backwards compatibility. </param>
        /// <param name="eventHubAuthorizationRuleId"> The resource Id for the event hub authorization rule. </param>
        /// <param name="eventHubName"> The name of the event hub. If none is specified, the default event hub will be selected. </param>
        /// <param name="metrics"> The list of metric settings. </param>
        /// <param name="logs"> The list of logs settings. </param>
        /// <param name="workspaceId"> The full ARM resource ID of the Log Analytics workspace to which you would like to send Diagnostic Logs. Example: /subscriptions/4b9e8510-67ab-4e9a-95a9-e2f1e570ea9c/resourceGroups/insights-integration/providers/Microsoft.OperationalInsights/workspaces/viruela2. </param>
        /// <param name="marketplacePartnerId"> The full ARM resource ID of the Marketplace resource to which you would like to send Diagnostic Logs. </param>
        /// <param name="logAnalyticsDestinationType"> A string indicating whether the export to Log Analytics should use the default destination type, i.e. AzureDiagnostics, or use a destination type constructed as follows: &lt;normalized service identity&gt;_&lt;normalized category name&gt;. Possible values are: Dedicated and null (null is default.). </param>
        /// <returns> A new <see cref="Monitor.DiagnosticSettingData"/> instance for mocking. </returns>
        public static DiagnosticSettingData DiagnosticSettingData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ResourceIdentifier storageAccountId = null, ResourceIdentifier serviceBusRuleId = null, ResourceIdentifier eventHubAuthorizationRuleId = null, string eventHubName = null, IEnumerable<MetricSettings> metrics = null, IEnumerable<LogSettings> logs = null, ResourceIdentifier workspaceId = null, ResourceIdentifier marketplacePartnerId = null, string logAnalyticsDestinationType = null)
        {
            metrics ??= new List<MetricSettings>();
            logs ??= new List<LogSettings>();

            return new DiagnosticSettingData(
                id,
                name,
                resourceType,
                systemData,
                storageAccountId,
                serviceBusRuleId,
                eventHubAuthorizationRuleId,
                eventHubName,
                metrics?.ToList(),
                logs?.ToList(),
                workspaceId,
                marketplacePartnerId,
                logAnalyticsDestinationType,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Monitor.DiagnosticSettingsCategoryData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="categoryType"> The type of the diagnostic settings category. </param>
        /// <param name="categoryGroups"> the collection of what category groups are supported. </param>
        /// <returns> A new <see cref="Monitor.DiagnosticSettingsCategoryData"/> instance for mocking. </returns>
        public static DiagnosticSettingsCategoryData DiagnosticSettingsCategoryData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, MonitorCategoryType? categoryType = null, IEnumerable<string> categoryGroups = null)
        {
            categoryGroups ??= new List<string>();

            return new DiagnosticSettingsCategoryData(
                id,
                name,
                resourceType,
                systemData,
                categoryType,
                categoryGroups?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Monitor.ActionGroupData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="groupShortName"> The short name of the action group. This will be used in SMS messages. </param>
        /// <param name="isEnabled"> Indicates whether this action group is enabled. If an action group is not enabled, then none of its receivers will receive communications. </param>
        /// <param name="emailReceivers"> The list of email receivers that are part of this action group. </param>
        /// <param name="smsReceivers"> The list of SMS receivers that are part of this action group. </param>
        /// <param name="webhookReceivers"> The list of webhook receivers that are part of this action group. </param>
        /// <param name="itsmReceivers"> The list of ITSM receivers that are part of this action group. </param>
        /// <param name="azureAppPushReceivers"> The list of AzureAppPush receivers that are part of this action group. </param>
        /// <param name="automationRunbookReceivers"> The list of AutomationRunbook receivers that are part of this action group. </param>
        /// <param name="voiceReceivers"> The list of voice receivers that are part of this action group. </param>
        /// <param name="logicAppReceivers"> The list of logic app receivers that are part of this action group. </param>
        /// <param name="azureFunctionReceivers"> The list of azure function receivers that are part of this action group. </param>
        /// <param name="armRoleReceivers"> The list of ARM role receivers that are part of this action group. Roles are Azure RBAC roles and only built-in roles are supported. </param>
        /// <param name="eventHubReceivers"> The list of event hub receivers that are part of this action group. </param>
        /// <returns> A new <see cref="Monitor.ActionGroupData"/> instance for mocking. </returns>
        public static ActionGroupData ActionGroupData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, string groupShortName = null, bool? isEnabled = null, IEnumerable<MonitorEmailReceiver> emailReceivers = null, IEnumerable<MonitorSmsReceiver> smsReceivers = null, IEnumerable<MonitorWebhookReceiver> webhookReceivers = null, IEnumerable<MonitorItsmReceiver> itsmReceivers = null, IEnumerable<MonitorAzureAppPushReceiver> azureAppPushReceivers = null, IEnumerable<MonitorAutomationRunbookReceiver> automationRunbookReceivers = null, IEnumerable<MonitorVoiceReceiver> voiceReceivers = null, IEnumerable<MonitorLogicAppReceiver> logicAppReceivers = null, IEnumerable<MonitorAzureFunctionReceiver> azureFunctionReceivers = null, IEnumerable<MonitorArmRoleReceiver> armRoleReceivers = null, IEnumerable<MonitorEventHubReceiver> eventHubReceivers = null)
        {
            tags ??= new Dictionary<string, string>();
            emailReceivers ??= new List<MonitorEmailReceiver>();
            smsReceivers ??= new List<MonitorSmsReceiver>();
            webhookReceivers ??= new List<MonitorWebhookReceiver>();
            itsmReceivers ??= new List<MonitorItsmReceiver>();
            azureAppPushReceivers ??= new List<MonitorAzureAppPushReceiver>();
            automationRunbookReceivers ??= new List<MonitorAutomationRunbookReceiver>();
            voiceReceivers ??= new List<MonitorVoiceReceiver>();
            logicAppReceivers ??= new List<MonitorLogicAppReceiver>();
            azureFunctionReceivers ??= new List<MonitorAzureFunctionReceiver>();
            armRoleReceivers ??= new List<MonitorArmRoleReceiver>();
            eventHubReceivers ??= new List<MonitorEventHubReceiver>();

            return new ActionGroupData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                groupShortName,
                isEnabled,
                emailReceivers?.ToList(),
                smsReceivers?.ToList(),
                webhookReceivers?.ToList(),
                itsmReceivers?.ToList(),
                azureAppPushReceivers?.ToList(),
                automationRunbookReceivers?.ToList(),
                voiceReceivers?.ToList(),
                logicAppReceivers?.ToList(),
                azureFunctionReceivers?.ToList(),
                armRoleReceivers?.ToList(),
                eventHubReceivers?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MonitorEmailReceiver"/>. </summary>
        /// <param name="name"> The name of the email receiver. Names must be unique across all receivers within an action group. </param>
        /// <param name="emailAddress"> The email address of this receiver. </param>
        /// <param name="useCommonAlertSchema"> Indicates whether to use common alert schema. </param>
        /// <param name="status"> The receiver status of the e-mail. </param>
        /// <returns> A new <see cref="Models.MonitorEmailReceiver"/> instance for mocking. </returns>
        public static MonitorEmailReceiver MonitorEmailReceiver(string name = null, string emailAddress = null, bool? useCommonAlertSchema = null, MonitorReceiverStatus? status = null)
        {
            return new MonitorEmailReceiver(name, emailAddress, useCommonAlertSchema, status, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MonitorSmsReceiver"/>. </summary>
        /// <param name="name"> The name of the SMS receiver. Names must be unique across all receivers within an action group. </param>
        /// <param name="countryCode"> The country code of the SMS receiver. </param>
        /// <param name="phoneNumber"> The phone number of the SMS receiver. </param>
        /// <param name="status"> The status of the receiver. </param>
        /// <returns> A new <see cref="Models.MonitorSmsReceiver"/> instance for mocking. </returns>
        public static MonitorSmsReceiver MonitorSmsReceiver(string name = null, string countryCode = null, string phoneNumber = null, MonitorReceiverStatus? status = null)
        {
            return new MonitorSmsReceiver(name, countryCode, phoneNumber, status, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.NotificationContent"/>. </summary>
        /// <param name="alertType"> The value of the supported alert type. Supported alert type values are: servicehealth, metricstaticthreshold, metricsdynamicthreshold, logalertv2, smartalert, webtestalert, logalertv1numresult, logalertv1metricmeasurement, resourcehealth, activitylog, actualcostbudget, forecastedbudget. </param>
        /// <param name="emailReceivers"> The list of email receivers that are part of this action group. </param>
        /// <param name="smsReceivers"> The list of SMS receivers that are part of this action group. </param>
        /// <param name="webhookReceivers"> The list of webhook receivers that are part of this action group. </param>
        /// <param name="itsmReceivers"> The list of ITSM receivers that are part of this action group. </param>
        /// <param name="azureAppPushReceivers"> The list of AzureAppPush receivers that are part of this action group. </param>
        /// <param name="automationRunbookReceivers"> The list of AutomationRunbook receivers that are part of this action group. </param>
        /// <param name="voiceReceivers"> The list of voice receivers that are part of this action group. </param>
        /// <param name="logicAppReceivers"> The list of logic app receivers that are part of this action group. </param>
        /// <param name="azureFunctionReceivers"> The list of azure function receivers that are part of this action group. </param>
        /// <param name="armRoleReceivers"> The list of ARM role receivers that are part of this action group. Roles are Azure RBAC roles and only built-in roles are supported. </param>
        /// <param name="eventHubReceivers"> The list of event hub receivers that are part of this action group. </param>
        /// <returns> A new <see cref="Models.NotificationContent"/> instance for mocking. </returns>
        public static NotificationContent NotificationContent(string alertType = null, IEnumerable<MonitorEmailReceiver> emailReceivers = null, IEnumerable<MonitorSmsReceiver> smsReceivers = null, IEnumerable<MonitorWebhookReceiver> webhookReceivers = null, IEnumerable<MonitorItsmReceiver> itsmReceivers = null, IEnumerable<MonitorAzureAppPushReceiver> azureAppPushReceivers = null, IEnumerable<MonitorAutomationRunbookReceiver> automationRunbookReceivers = null, IEnumerable<MonitorVoiceReceiver> voiceReceivers = null, IEnumerable<MonitorLogicAppReceiver> logicAppReceivers = null, IEnumerable<MonitorAzureFunctionReceiver> azureFunctionReceivers = null, IEnumerable<MonitorArmRoleReceiver> armRoleReceivers = null, IEnumerable<MonitorEventHubReceiver> eventHubReceivers = null)
        {
            emailReceivers ??= new List<MonitorEmailReceiver>();
            smsReceivers ??= new List<MonitorSmsReceiver>();
            webhookReceivers ??= new List<MonitorWebhookReceiver>();
            itsmReceivers ??= new List<MonitorItsmReceiver>();
            azureAppPushReceivers ??= new List<MonitorAzureAppPushReceiver>();
            automationRunbookReceivers ??= new List<MonitorAutomationRunbookReceiver>();
            voiceReceivers ??= new List<MonitorVoiceReceiver>();
            logicAppReceivers ??= new List<MonitorLogicAppReceiver>();
            azureFunctionReceivers ??= new List<MonitorAzureFunctionReceiver>();
            armRoleReceivers ??= new List<MonitorArmRoleReceiver>();
            eventHubReceivers ??= new List<MonitorEventHubReceiver>();

            return new NotificationContent(
                alertType,
                emailReceivers?.ToList(),
                smsReceivers?.ToList(),
                webhookReceivers?.ToList(),
                itsmReceivers?.ToList(),
                azureAppPushReceivers?.ToList(),
                automationRunbookReceivers?.ToList(),
                voiceReceivers?.ToList(),
                logicAppReceivers?.ToList(),
                azureFunctionReceivers?.ToList(),
                armRoleReceivers?.ToList(),
                eventHubReceivers?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.NotificationStatus"/>. </summary>
        /// <param name="context"> The context info. </param>
        /// <param name="state"> The overall state. </param>
        /// <param name="completedOn"> The completed time. </param>
        /// <param name="createdOn"> The created time. </param>
        /// <param name="actionDetails"> The list of action detail. </param>
        /// <returns> A new <see cref="Models.NotificationStatus"/> instance for mocking. </returns>
        public static NotificationStatus NotificationStatus(NotificationContext context = null, string state = null, DateTimeOffset? completedOn = null, DateTimeOffset? createdOn = null, IEnumerable<NotificationActionDetail> actionDetails = null)
        {
            actionDetails ??= new List<NotificationActionDetail>();

            return new NotificationStatus(
                context,
                state,
                completedOn,
                createdOn,
                actionDetails?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.NotificationContext"/>. </summary>
        /// <param name="notificationSource"> The source of the notification request. </param>
        /// <param name="contextType"> The context id type. </param>
        /// <returns> A new <see cref="Models.NotificationContext"/> instance for mocking. </returns>
        public static NotificationContext NotificationContext(string notificationSource = null, string contextType = null)
        {
            return new NotificationContext(notificationSource, contextType, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.NotificationActionDetail"/>. </summary>
        /// <param name="mechanismType"> The mechanism type. </param>
        /// <param name="name"> The name of the action. </param>
        /// <param name="status"> The status of the action. </param>
        /// <param name="subState"> The substatus of the action. </param>
        /// <param name="sendOn"> The send time. </param>
        /// <param name="detail"> The detail of the friendly error message. </param>
        /// <returns> A new <see cref="Models.NotificationActionDetail"/> instance for mocking. </returns>
        public static NotificationActionDetail NotificationActionDetail(string mechanismType = null, string name = null, string status = null, string subState = null, DateTimeOffset? sendOn = null, string detail = null)
        {
            return new NotificationActionDetail(
                mechanismType,
                name,
                status,
                subState,
                sendOn,
                detail,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.EventDataInfo"/>. </summary>
        /// <param name="authorization"> The sender authorization information. </param>
        /// <param name="claims"> key value pairs to identify ARM permissions. </param>
        /// <param name="caller"> the email address of the user who has performed the operation, the UPN claim or SPN claim based on availability. </param>
        /// <param name="description"> the description of the event. </param>
        /// <param name="id"> the Id of this event as required by ARM for RBAC. It contains the EventDataID and a timestamp information. </param>
        /// <param name="eventDataId"> the event data Id. This is a unique identifier for an event. </param>
        /// <param name="correlationId"> the correlation Id, usually a GUID in the string format. The correlation Id is shared among the events that belong to the same uber operation. </param>
        /// <param name="eventName"> the event name. This value should not be confused with OperationName. For practical purposes, OperationName might be more appealing to end users. </param>
        /// <param name="category"> the event category. </param>
        /// <param name="httpRequest"> the HTTP request info. Usually includes the 'clientRequestId', 'clientIpAddress' (IP address of the user who initiated the event) and 'method' (HTTP method e.g. PUT). </param>
        /// <param name="level"> the event level. </param>
        /// <param name="resourceGroupName"> the resource group name of the impacted resource. </param>
        /// <param name="resourceProviderName"> the resource provider name of the impacted resource. </param>
        /// <param name="resourceId"> the resource uri that uniquely identifies the resource that caused this event. </param>
        /// <param name="resourceType"> the resource type. </param>
        /// <param name="operationId"> It is usually a GUID shared among the events corresponding to single operation. This value should not be confused with EventName. </param>
        /// <param name="operationName"> the operation name. </param>
        /// <param name="properties"> the set of &lt;Key, Value&gt; pairs (usually a Dictionary&lt;String, String&gt;) that includes details about the event. </param>
        /// <param name="status"> a string describing the status of the operation. Some typical values are: Started, In progress, Succeeded, Failed, Resolved. </param>
        /// <param name="subStatus"> the event sub status. Most of the time, when included, this captures the HTTP status code of the REST call. Common values are: OK (HTTP Status Code: 200), Created (HTTP Status Code: 201), Accepted (HTTP Status Code: 202), No Content (HTTP Status Code: 204), Bad Request(HTTP Status Code: 400), Not Found (HTTP Status Code: 404), Conflict (HTTP Status Code: 409), Internal Server Error (HTTP Status Code: 500), Service Unavailable (HTTP Status Code:503), Gateway Timeout (HTTP Status Code: 504). </param>
        /// <param name="eventTimestamp"> the timestamp of when the event was generated by the Azure service processing the request corresponding the event. It in ISO 8601 format. </param>
        /// <param name="submissionTimestamp"> the timestamp of when the event became available for querying via this API. It is in ISO 8601 format. This value should not be confused eventTimestamp. As there might be a delay between the occurrence time of the event, and the time that the event is submitted to the Azure logging infrastructure. </param>
        /// <param name="subscriptionId"> the Azure subscription Id usually a GUID. </param>
        /// <param name="tenantId"> the Azure tenant Id. </param>
        /// <returns> A new <see cref="Models.EventDataInfo"/> instance for mocking. </returns>
        public static EventDataInfo EventDataInfo(SenderAuthorization authorization = null, IReadOnlyDictionary<string, string> claims = null, string caller = null, string description = null, string id = null, string eventDataId = null, string correlationId = null, MonitorLocalizableString eventName = null, MonitorLocalizableString category = null, EventDataHttpRequestInfo httpRequest = null, MonitorEventLevel? level = null, string resourceGroupName = null, MonitorLocalizableString resourceProviderName = null, ResourceIdentifier resourceId = null, MonitorLocalizableString resourceType = null, string operationId = null, MonitorLocalizableString operationName = null, IReadOnlyDictionary<string, string> properties = null, MonitorLocalizableString status = null, MonitorLocalizableString subStatus = null, DateTimeOffset? eventTimestamp = null, DateTimeOffset? submissionTimestamp = null, string subscriptionId = null, Guid? tenantId = null)
        {
            claims ??= new Dictionary<string, string>();
            properties ??= new Dictionary<string, string>();

            return new EventDataInfo(
                authorization,
                claims,
                caller,
                description,
                id,
                eventDataId,
                correlationId,
                eventName,
                category,
                httpRequest,
                level,
                resourceGroupName,
                resourceProviderName,
                resourceId,
                resourceType,
                operationId,
                operationName,
                properties,
                status,
                subStatus,
                eventTimestamp,
                submissionTimestamp,
                subscriptionId,
                tenantId,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SenderAuthorization"/>. </summary>
        /// <param name="action"> the permissible actions. For instance: microsoft.support/supporttickets/write. </param>
        /// <param name="role"> the role of the user. For instance: Subscription Admin. </param>
        /// <param name="scope"> the scope. </param>
        /// <returns> A new <see cref="Models.SenderAuthorization"/> instance for mocking. </returns>
        public static SenderAuthorization SenderAuthorization(string action = null, string role = null, string scope = null)
        {
            return new SenderAuthorization(action, role, scope, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MonitorLocalizableString"/>. </summary>
        /// <param name="value"> the invariant value. </param>
        /// <param name="localizedValue"> the locale specific value. </param>
        /// <returns> A new <see cref="Models.MonitorLocalizableString"/> instance for mocking. </returns>
        public static MonitorLocalizableString MonitorLocalizableString(string value = null, string localizedValue = null)
        {
            return new MonitorLocalizableString(value, localizedValue, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.EventDataHttpRequestInfo"/>. </summary>
        /// <param name="clientRequestId"> the client request id. </param>
        /// <param name="clientIPAddress"> the client Ip Address. </param>
        /// <param name="method"> the Http request method. </param>
        /// <param name="uri"> the Uri. </param>
        /// <returns> A new <see cref="Models.EventDataHttpRequestInfo"/> instance for mocking. </returns>
        public static EventDataHttpRequestInfo EventDataHttpRequestInfo(string clientRequestId = null, IPAddress clientIPAddress = null, string method = null, Uri uri = null)
        {
            return new EventDataHttpRequestInfo(clientRequestId, clientIPAddress, method, uri, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MonitorMetricDefinition"/>. </summary>
        /// <param name="isDimensionRequired"> Flag to indicate whether the dimension is required. </param>
        /// <param name="resourceId"> the resource identifier of the resource that emitted the metric. </param>
        /// <param name="namespace"> the namespace the metric belongs to. </param>
        /// <param name="name"> the name and the display name of the metric, i.e. it is a localizable string. </param>
        /// <param name="displayDescription"> Detailed description of this metric. </param>
        /// <param name="category"> Custom category name for this metric. </param>
        /// <param name="metricClass"> The class of the metric. </param>
        /// <param name="unit"> The unit of the metric. </param>
        /// <param name="primaryAggregationType"> the primary aggregation type value defining how to use the values for display. </param>
        /// <param name="supportedAggregationTypes"> the collection of what aggregation types are supported. </param>
        /// <param name="metricAvailabilities"> the collection of what aggregation intervals are available to be queried. </param>
        /// <param name="id"> the resource identifier of the metric definition. </param>
        /// <param name="dimensions"> the name and the display name of the dimension, i.e. it is a localizable string. </param>
        /// <returns> A new <see cref="Models.MonitorMetricDefinition"/> instance for mocking. </returns>
        public static MonitorMetricDefinition MonitorMetricDefinition(bool? isDimensionRequired = null, string resourceId = null, string @namespace = null, MonitorLocalizableString name = null, string displayDescription = null, string category = null, MonitorMetricClass? metricClass = null, MonitorMetricUnit? unit = null, MonitorAggregationType? primaryAggregationType = null, IEnumerable<MonitorAggregationType> supportedAggregationTypes = null, IEnumerable<MonitorMetricAvailability> metricAvailabilities = null, string id = null, IEnumerable<MonitorLocalizableString> dimensions = null)
        {
            supportedAggregationTypes ??= new List<MonitorAggregationType>();
            metricAvailabilities ??= new List<MonitorMetricAvailability>();
            dimensions ??= new List<MonitorLocalizableString>();

            return new MonitorMetricDefinition(
                isDimensionRequired,
                resourceId,
                @namespace,
                name,
                displayDescription,
                category,
                metricClass,
                unit,
                primaryAggregationType,
                supportedAggregationTypes?.ToList(),
                metricAvailabilities?.ToList(),
                id,
                dimensions?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MonitorMetricAvailability"/>. </summary>
        /// <param name="timeGrain"> the time grain specifies the aggregation interval for the metric. Expressed as a duration 'PT1M', 'P1D', etc. </param>
        /// <param name="retention"> the retention period for the metric at the specified timegrain.  Expressed as a duration 'PT1M', 'P1D', etc. </param>
        /// <returns> A new <see cref="Models.MonitorMetricAvailability"/> instance for mocking. </returns>
        public static MonitorMetricAvailability MonitorMetricAvailability(TimeSpan? timeGrain = null, TimeSpan? retention = null)
        {
            return new MonitorMetricAvailability(timeGrain, retention, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.SubscriptionMonitorMetric"/>. </summary>
        /// <param name="id"> the metric Id. </param>
        /// <param name="subscriptionScopeMetricType"> the resource type of the metric resource. </param>
        /// <param name="name"> the name and the display name of the metric, i.e. it is localizable string. </param>
        /// <param name="displayDescription"> Detailed description of this metric. </param>
        /// <param name="errorCode"> 'Success' or the error details on query failures for this metric. </param>
        /// <param name="errorMessage"> Error message encountered querying this specific metric. </param>
        /// <param name="unit"> The unit of the metric. </param>
        /// <param name="timeseries"> the time series returned when a data query is performed. </param>
        /// <returns> A new <see cref="Models.SubscriptionMonitorMetric"/> instance for mocking. </returns>
        public static SubscriptionMonitorMetric SubscriptionMonitorMetric(string id = null, string subscriptionScopeMetricType = null, MonitorLocalizableString name = null, string displayDescription = null, string errorCode = null, string errorMessage = null, MonitorMetricUnit unit = default, IEnumerable<MonitorTimeSeriesElement> timeseries = null)
        {
            timeseries ??= new List<MonitorTimeSeriesElement>();

            return new SubscriptionMonitorMetric(
                id,
                subscriptionScopeMetricType,
                name,
                displayDescription,
                errorCode,
                errorMessage,
                unit,
                timeseries?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MonitorTimeSeriesElement"/>. </summary>
        /// <param name="metadatavalues"> the metadata values returned if $filter was specified in the call. </param>
        /// <param name="data"> An array of data points representing the metric values.  This is only returned if a result type of data is specified. </param>
        /// <returns> A new <see cref="Models.MonitorTimeSeriesElement"/> instance for mocking. </returns>
        public static MonitorTimeSeriesElement MonitorTimeSeriesElement(IEnumerable<MonitorMetadataValue> metadatavalues = null, IEnumerable<MonitorMetricValue> data = null)
        {
            metadatavalues ??= new List<MonitorMetadataValue>();
            data ??= new List<MonitorMetricValue>();

            return new MonitorTimeSeriesElement(metadatavalues?.ToList(), data?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MonitorMetadataValue"/>. </summary>
        /// <param name="name"> the name of the metadata. </param>
        /// <param name="value"> the value of the metadata. </param>
        /// <returns> A new <see cref="Models.MonitorMetadataValue"/> instance for mocking. </returns>
        public static MonitorMetadataValue MonitorMetadataValue(MonitorLocalizableString name = null, string value = null)
        {
            return new MonitorMetadataValue(name, value, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MonitorMetricValue"/>. </summary>
        /// <param name="timeStamp"> the timestamp for the metric value in ISO 8601 format. </param>
        /// <param name="average"> the average value in the time range. </param>
        /// <param name="minimum"> the least value in the time range. </param>
        /// <param name="maximum"> the greatest value in the time range. </param>
        /// <param name="total"> the sum of all of the values in the time range. </param>
        /// <param name="count"> the number of samples in the time range. Can be used to determine the number of values that contributed to the average value. </param>
        /// <returns> A new <see cref="Models.MonitorMetricValue"/> instance for mocking. </returns>
        public static MonitorMetricValue MonitorMetricValue(DateTimeOffset timeStamp = default, double? average = null, double? minimum = null, double? maximum = null, double? total = null, double? count = null)
        {
            return new MonitorMetricValue(
                timeStamp,
                average,
                minimum,
                maximum,
                total,
                count,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MonitorMetric"/>. </summary>
        /// <param name="id"> the metric Id. </param>
        /// <param name="metricType"> the resource type of the metric resource. </param>
        /// <param name="name"> the name and the display name of the metric, i.e. it is localizable string. </param>
        /// <param name="displayDescription"> Detailed description of this metric. </param>
        /// <param name="errorCode"> 'Success' or the error details on query failures for this metric. </param>
        /// <param name="errorMessage"> Error message encountered querying this specific metric. </param>
        /// <param name="unit"> The unit of the metric. </param>
        /// <param name="timeseries"> the time series returned when a data query is performed. </param>
        /// <returns> A new <see cref="Models.MonitorMetric"/> instance for mocking. </returns>
        public static MonitorMetric MonitorMetric(string id = null, string metricType = null, MonitorLocalizableString name = null, string displayDescription = null, string errorCode = null, string errorMessage = null, MonitorMetricUnit unit = default, IEnumerable<MonitorTimeSeriesElement> timeseries = null)
        {
            timeseries ??= new List<MonitorTimeSeriesElement>();

            return new MonitorMetric(
                id,
                metricType,
                name,
                displayDescription,
                errorCode,
                errorMessage,
                unit,
                timeseries?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MonitorSingleMetricBaseline"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="timespan"> The timespan for which the data was retrieved. Its value consists of two datetimes concatenated, separated by '/'.  This may be adjusted in the future and returned back from what was originally requested. </param>
        /// <param name="interval"> The interval (window size) for which the metric data was returned in.  This may be adjusted in the future and returned back from what was originally requested.  This is not present if a metadata request was made. </param>
        /// <param name="namespace"> The namespace of the metrics been queried. </param>
        /// <param name="baselines"> The baseline for each time series that was queried. </param>
        /// <returns> A new <see cref="Models.MonitorSingleMetricBaseline"/> instance for mocking. </returns>
        public static MonitorSingleMetricBaseline MonitorSingleMetricBaseline(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string timespan = null, TimeSpan interval = default, string @namespace = null, IEnumerable<MonitorTimeSeriesBaseline> baselines = null)
        {
            baselines ??= new List<MonitorTimeSeriesBaseline>();

            return new MonitorSingleMetricBaseline(
                id,
                name,
                resourceType,
                systemData,
                timespan,
                interval,
                @namespace,
                baselines?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MonitorTimeSeriesBaseline"/>. </summary>
        /// <param name="aggregation"> The aggregation type of the metric. </param>
        /// <param name="dimensions"> The dimensions of this time series. </param>
        /// <param name="timestamps"> The list of timestamps of the baselines. </param>
        /// <param name="data"> The baseline values for each sensitivity. </param>
        /// <param name="metadataValues"> The baseline metadata values. </param>
        /// <returns> A new <see cref="Models.MonitorTimeSeriesBaseline"/> instance for mocking. </returns>
        public static MonitorTimeSeriesBaseline MonitorTimeSeriesBaseline(string aggregation = null, IEnumerable<MonitorMetricSingleDimension> dimensions = null, IEnumerable<DateTimeOffset> timestamps = null, IEnumerable<MonitorSingleBaseline> data = null, IEnumerable<MonitorBaselineMetadata> metadataValues = null)
        {
            dimensions ??= new List<MonitorMetricSingleDimension>();
            timestamps ??= new List<DateTimeOffset>();
            data ??= new List<MonitorSingleBaseline>();
            metadataValues ??= new List<MonitorBaselineMetadata>();

            return new MonitorTimeSeriesBaseline(
                aggregation,
                dimensions?.ToList(),
                timestamps?.ToList(),
                data?.ToList(),
                metadataValues?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MonitorMetricSingleDimension"/>. </summary>
        /// <param name="name"> Name of the dimension. </param>
        /// <param name="value"> Value of the dimension. </param>
        /// <returns> A new <see cref="Models.MonitorMetricSingleDimension"/> instance for mocking. </returns>
        public static MonitorMetricSingleDimension MonitorMetricSingleDimension(string name = null, string value = null)
        {
            return new MonitorMetricSingleDimension(name, value, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MonitorSingleBaseline"/>. </summary>
        /// <param name="sensitivity"> the sensitivity of the baseline. </param>
        /// <param name="lowThresholds"> The low thresholds of the baseline. </param>
        /// <param name="highThresholds"> The high thresholds of the baseline. </param>
        /// <returns> A new <see cref="Models.MonitorSingleBaseline"/> instance for mocking. </returns>
        public static MonitorSingleBaseline MonitorSingleBaseline(MonitorBaselineSensitivity sensitivity = default, IEnumerable<double> lowThresholds = null, IEnumerable<double> highThresholds = null)
        {
            lowThresholds ??= new List<double>();
            highThresholds ??= new List<double>();

            return new MonitorSingleBaseline(sensitivity, lowThresholds?.ToList(), highThresholds?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MonitorBaselineMetadata"/>. </summary>
        /// <param name="name"> Name of the baseline metadata. </param>
        /// <param name="value"> Value of the baseline metadata. </param>
        /// <returns> A new <see cref="Models.MonitorBaselineMetadata"/> instance for mocking. </returns>
        public static MonitorBaselineMetadata MonitorBaselineMetadata(string name = null, string value = null)
        {
            return new MonitorBaselineMetadata(name, value, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Monitor.MetricAlertData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="description"> the description of the metric alert that will be included in the alert email. </param>
        /// <param name="severity"> Alert severity {0, 1, 2, 3, 4}. </param>
        /// <param name="isEnabled"> the flag that indicates whether the metric alert is enabled. </param>
        /// <param name="scopes"> the list of resource id's that this metric alert is scoped to. </param>
        /// <param name="evaluationFrequency"> how often the metric alert is evaluated represented in ISO 8601 duration format. </param>
        /// <param name="windowSize"> the period of time (in ISO 8601 duration format) that is used to monitor alert activity based on the threshold. </param>
        /// <param name="targetResourceType"> the resource type of the target resource(s) on which the alert is created/updated. Mandatory if the scope contains a subscription, resource group, or more than one resource. </param>
        /// <param name="targetResourceRegion"> the region of the target resource(s) on which the alert is created/updated. Mandatory if the scope contains a subscription, resource group, or more than one resource. </param>
        /// <param name="criteria">
        /// defines the specific alert criteria information.
        /// Please note <see cref="MetricAlertCriteria"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="MetricAlertMultipleResourceMultipleMetricCriteria"/>, <see cref="MetricAlertSingleResourceMultipleMetricCriteria"/> and <see cref="WebtestLocationAvailabilityCriteria"/>.
        /// </param>
        /// <param name="isAutoMitigateEnabled"> the flag that indicates whether the alert should be auto resolved or not. The default is true. </param>
        /// <param name="actions"> the array of actions that are performed when the alert rule becomes active, and when an alert condition is resolved. </param>
        /// <param name="lastUpdatedOn"> Last time the rule was updated in ISO8601 format. </param>
        /// <param name="isMigrated"> the value indicating whether this alert rule is migrated. </param>
        /// <returns> A new <see cref="Monitor.MetricAlertData"/> instance for mocking. </returns>
        public static MetricAlertData MetricAlertData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, string description = null, int severity = default, bool isEnabled = default, IEnumerable<string> scopes = null, TimeSpan evaluationFrequency = default, TimeSpan windowSize = default, ResourceType? targetResourceType = null, AzureLocation? targetResourceRegion = null, MetricAlertCriteria criteria = null, bool? isAutoMitigateEnabled = null, IEnumerable<MetricAlertAction> actions = null, DateTimeOffset? lastUpdatedOn = null, bool? isMigrated = null)
        {
            tags ??= new Dictionary<string, string>();
            scopes ??= new List<string>();
            actions ??= new List<MetricAlertAction>();

            return new MetricAlertData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                description,
                severity,
                isEnabled,
                scopes?.ToList(),
                evaluationFrequency,
                windowSize,
                targetResourceType,
                targetResourceRegion,
                criteria,
                isAutoMitigateEnabled,
                actions?.ToList(),
                lastUpdatedOn,
                isMigrated,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MetricAlertPatch"/>. </summary>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="description"> the description of the metric alert that will be included in the alert email. </param>
        /// <param name="severity"> Alert severity {0, 1, 2, 3, 4}. </param>
        /// <param name="isEnabled"> the flag that indicates whether the metric alert is enabled. </param>
        /// <param name="scopes"> the list of resource id's that this metric alert is scoped to. </param>
        /// <param name="evaluationFrequency"> how often the metric alert is evaluated represented in ISO 8601 duration format. </param>
        /// <param name="windowSize"> the period of time (in ISO 8601 duration format) that is used to monitor alert activity based on the threshold. </param>
        /// <param name="targetResourceType"> the resource type of the target resource(s) on which the alert is created/updated. Mandatory for MultipleResourceMultipleMetricCriteria. </param>
        /// <param name="targetResourceRegion"> the region of the target resource(s) on which the alert is created/updated. Mandatory for MultipleResourceMultipleMetricCriteria. </param>
        /// <param name="criteria">
        /// defines the specific alert criteria information.
        /// Please note <see cref="MetricAlertCriteria"/> is the base class. According to the scenario, a derived class of the base class might need to be assigned here, or this property needs to be casted to one of the possible derived classes.
        /// The available derived classes include <see cref="MetricAlertMultipleResourceMultipleMetricCriteria"/>, <see cref="MetricAlertSingleResourceMultipleMetricCriteria"/> and <see cref="WebtestLocationAvailabilityCriteria"/>.
        /// </param>
        /// <param name="isAutoMitigateEnabled"> the flag that indicates whether the alert should be auto resolved or not. The default is true. </param>
        /// <param name="actions"> the array of actions that are performed when the alert rule becomes active, and when an alert condition is resolved. </param>
        /// <param name="lastUpdatedOn"> Last time the rule was updated in ISO8601 format. </param>
        /// <param name="isMigrated"> the value indicating whether this alert rule is migrated. </param>
        /// <returns> A new <see cref="Models.MetricAlertPatch"/> instance for mocking. </returns>
        public static MetricAlertPatch MetricAlertPatch(IDictionary<string, string> tags = null, string description = null, int? severity = null, bool? isEnabled = null, IEnumerable<string> scopes = null, TimeSpan? evaluationFrequency = null, TimeSpan? windowSize = null, ResourceType? targetResourceType = null, AzureLocation? targetResourceRegion = null, MetricAlertCriteria criteria = null, bool? isAutoMitigateEnabled = null, IEnumerable<MetricAlertAction> actions = null, DateTimeOffset? lastUpdatedOn = null, bool? isMigrated = null)
        {
            tags ??= new Dictionary<string, string>();
            scopes ??= new List<string>();
            actions ??= new List<MetricAlertAction>();

            return new MetricAlertPatch(
                tags,
                description,
                severity,
                isEnabled,
                scopes?.ToList(),
                evaluationFrequency,
                windowSize,
                targetResourceType,
                targetResourceRegion,
                criteria,
                isAutoMitigateEnabled,
                actions?.ToList(),
                lastUpdatedOn,
                isMigrated,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MetricAlertStatus"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="properties"> The alert status properties of the metric alert status. </param>
        /// <returns> A new <see cref="Models.MetricAlertStatus"/> instance for mocking. </returns>
        public static MetricAlertStatus MetricAlertStatus(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, MetricAlertStatusProperties properties = null)
        {
            return new MetricAlertStatus(
                id,
                name,
                resourceType,
                systemData,
                properties,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MetricAlertStatusProperties"/>. </summary>
        /// <param name="dimensions"> An object describing the type of the dimensions. </param>
        /// <param name="status"> status value. </param>
        /// <param name="timestamp"> UTC time when the status was checked. </param>
        /// <returns> A new <see cref="Models.MetricAlertStatusProperties"/> instance for mocking. </returns>
        public static MetricAlertStatusProperties MetricAlertStatusProperties(IReadOnlyDictionary<string, string> dimensions = null, string status = null, DateTimeOffset? timestamp = null)
        {
            dimensions ??= new Dictionary<string, string>();

            return new MetricAlertStatusProperties(dimensions, status, timestamp, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Monitor.ScheduledQueryRuleData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="kind"> Indicates the type of scheduled query rule. The default is LogAlert. </param>
        /// <param name="etag"> The etag field is *not* required. If it is provided in the response body, it must also be provided as a header per the normal etag convention.  Entity tags are used for comparing two or more entities from the same requested resource. HTTP/1.1 uses entity tags in the etag (section 14.19), If-Match (section 14.24), If-None-Match (section 14.26), and If-Range (section 14.27) header fields. </param>
        /// <param name="createdWithApiVersion"> The api-version used when creating this alert rule. </param>
        /// <param name="isLegacyLogAnalyticsRule"> True if alert rule is legacy Log Analytic rule. </param>
        /// <param name="description"> The description of the scheduled query rule. </param>
        /// <param name="displayName"> The display name of the alert rule. </param>
        /// <param name="severity"> Severity of the alert. Should be an integer between [0-4]. Value of 0 is severest. Relevant and required only for rules of the kind LogAlert. </param>
        /// <param name="isEnabled"> The flag which indicates whether this scheduled query rule is enabled. Value should be true or false. </param>
        /// <param name="scopes"> The list of resource id's that this scheduled query rule is scoped to. </param>
        /// <param name="evaluationFrequency"> How often the scheduled query rule is evaluated represented in ISO 8601 duration format. Relevant and required only for rules of the kind LogAlert. </param>
        /// <param name="windowSize"> The period of time (in ISO 8601 duration format) on which the Alert query will be executed (bin size). Relevant and required only for rules of the kind LogAlert. </param>
        /// <param name="overrideQueryTimeRange"> If specified then overrides the query time range (default is WindowSize*NumberOfEvaluationPeriods). Relevant only for rules of the kind LogAlert. </param>
        /// <param name="targetResourceTypes"> List of resource type of the target resource(s) on which the alert is created/updated. For example if the scope is a resource group and targetResourceTypes is Microsoft.Compute/virtualMachines, then a different alert will be fired for each virtual machine in the resource group which meet the alert criteria. Relevant only for rules of the kind LogAlert. </param>
        /// <param name="criteriaAllOf"> The rule criteria that defines the conditions of the scheduled query rule. </param>
        /// <param name="muteActionsDuration"> Mute actions for the chosen period of time (in ISO 8601 duration format) after the alert is fired. Relevant only for rules of the kind LogAlert. </param>
        /// <param name="actions"> Actions to invoke when the alert fires. </param>
        /// <param name="isWorkspaceAlertsStorageConfigured"> The flag which indicates whether this scheduled query rule has been configured to be stored in the customer's storage. The default is false. </param>
        /// <param name="checkWorkspaceAlertsStorageConfigured"> The flag which indicates whether this scheduled query rule should be stored in the customer's storage. The default is false. Relevant only for rules of the kind LogAlert. </param>
        /// <param name="skipQueryValidation"> The flag which indicates whether the provided query should be validated or not. The default is false. Relevant only for rules of the kind LogAlert. </param>
        /// <param name="autoMitigate"> The flag that indicates whether the alert should be automatically resolved or not. The default is true. Relevant only for rules of the kind LogAlert. </param>
        /// <returns> A new <see cref="Monitor.ScheduledQueryRuleData"/> instance for mocking. </returns>
        public static ScheduledQueryRuleData ScheduledQueryRuleData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, ScheduledQueryRuleKind? kind = null, ETag? etag = null, string createdWithApiVersion = null, bool? isLegacyLogAnalyticsRule = null, string description = null, string displayName = null, AlertSeverity? severity = null, bool? isEnabled = null, IEnumerable<string> scopes = null, TimeSpan? evaluationFrequency = null, TimeSpan? windowSize = null, TimeSpan? overrideQueryTimeRange = null, IEnumerable<string> targetResourceTypes = null, IEnumerable<ScheduledQueryRuleCondition> criteriaAllOf = null, TimeSpan? muteActionsDuration = null, ScheduledQueryRuleActions actions = null, bool? isWorkspaceAlertsStorageConfigured = null, bool? checkWorkspaceAlertsStorageConfigured = null, bool? skipQueryValidation = null, bool? autoMitigate = null)
        {
            tags ??= new Dictionary<string, string>();
            scopes ??= new List<string>();
            targetResourceTypes ??= new List<string>();
            criteriaAllOf ??= new List<ScheduledQueryRuleCondition>();

            return new ScheduledQueryRuleData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                kind,
                etag,
                createdWithApiVersion,
                isLegacyLogAnalyticsRule,
                description,
                displayName,
                severity,
                isEnabled,
                scopes?.ToList(),
                evaluationFrequency,
                windowSize,
                overrideQueryTimeRange,
                targetResourceTypes?.ToList(),
                criteriaAllOf != null ? new ScheduledQueryRuleCriteria(criteriaAllOf?.ToList(), serializedAdditionalRawData: null) : null,
                muteActionsDuration,
                actions,
                isWorkspaceAlertsStorageConfigured,
                checkWorkspaceAlertsStorageConfigured,
                skipQueryValidation,
                autoMitigate,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.ScheduledQueryRulePatch"/>. </summary>
        /// <param name="tags"> Resource tags. </param>
        /// <param name="createdWithApiVersion"> The api-version used when creating this alert rule. </param>
        /// <param name="isLegacyLogAnalyticsRule"> True if alert rule is legacy Log Analytic rule. </param>
        /// <param name="description"> The description of the scheduled query rule. </param>
        /// <param name="displayName"> The display name of the alert rule. </param>
        /// <param name="severity"> Severity of the alert. Should be an integer between [0-4]. Value of 0 is severest. Relevant and required only for rules of the kind LogAlert. </param>
        /// <param name="isEnabled"> The flag which indicates whether this scheduled query rule is enabled. Value should be true or false. </param>
        /// <param name="scopes"> The list of resource id's that this scheduled query rule is scoped to. </param>
        /// <param name="evaluationFrequency"> How often the scheduled query rule is evaluated represented in ISO 8601 duration format. Relevant and required only for rules of the kind LogAlert. </param>
        /// <param name="windowSize"> The period of time (in ISO 8601 duration format) on which the Alert query will be executed (bin size). Relevant and required only for rules of the kind LogAlert. </param>
        /// <param name="overrideQueryTimeRange"> If specified then overrides the query time range (default is WindowSize*NumberOfEvaluationPeriods). Relevant only for rules of the kind LogAlert. </param>
        /// <param name="targetResourceTypes"> List of resource type of the target resource(s) on which the alert is created/updated. For example if the scope is a resource group and targetResourceTypes is Microsoft.Compute/virtualMachines, then a different alert will be fired for each virtual machine in the resource group which meet the alert criteria. Relevant only for rules of the kind LogAlert. </param>
        /// <param name="criteriaAllOf"> The rule criteria that defines the conditions of the scheduled query rule. </param>
        /// <param name="muteActionsDuration"> Mute actions for the chosen period of time (in ISO 8601 duration format) after the alert is fired. Relevant only for rules of the kind LogAlert. </param>
        /// <param name="actions"> Actions to invoke when the alert fires. </param>
        /// <param name="isWorkspaceAlertsStorageConfigured"> The flag which indicates whether this scheduled query rule has been configured to be stored in the customer's storage. The default is false. </param>
        /// <param name="checkWorkspaceAlertsStorageConfigured"> The flag which indicates whether this scheduled query rule should be stored in the customer's storage. The default is false. Relevant only for rules of the kind LogAlert. </param>
        /// <param name="skipQueryValidation"> The flag which indicates whether the provided query should be validated or not. The default is false. Relevant only for rules of the kind LogAlert. </param>
        /// <param name="autoMitigate"> The flag that indicates whether the alert should be automatically resolved or not. The default is true. Relevant only for rules of the kind LogAlert. </param>
        /// <returns> A new <see cref="Models.ScheduledQueryRulePatch"/> instance for mocking. </returns>
        public static ScheduledQueryRulePatch ScheduledQueryRulePatch(IDictionary<string, string> tags = null, string createdWithApiVersion = null, bool? isLegacyLogAnalyticsRule = null, string description = null, string displayName = null, AlertSeverity? severity = null, bool? isEnabled = null, IEnumerable<string> scopes = null, TimeSpan? evaluationFrequency = null, TimeSpan? windowSize = null, TimeSpan? overrideQueryTimeRange = null, IEnumerable<string> targetResourceTypes = null, IEnumerable<ScheduledQueryRuleCondition> criteriaAllOf = null, TimeSpan? muteActionsDuration = null, ScheduledQueryRuleActions actions = null, bool? isWorkspaceAlertsStorageConfigured = null, bool? checkWorkspaceAlertsStorageConfigured = null, bool? skipQueryValidation = null, bool? autoMitigate = null)
        {
            tags ??= new Dictionary<string, string>();
            scopes ??= new List<string>();
            targetResourceTypes ??= new List<string>();
            criteriaAllOf ??= new List<ScheduledQueryRuleCondition>();

            return new ScheduledQueryRulePatch(
                tags,
                createdWithApiVersion,
                isLegacyLogAnalyticsRule,
                description,
                displayName,
                severity,
                isEnabled,
                scopes?.ToList(),
                evaluationFrequency,
                windowSize,
                overrideQueryTimeRange,
                targetResourceTypes?.ToList(),
                criteriaAllOf != null ? new ScheduledQueryRuleCriteria(criteriaAllOf?.ToList(), serializedAdditionalRawData: null) : null,
                muteActionsDuration,
                actions,
                isWorkspaceAlertsStorageConfigured,
                checkWorkspaceAlertsStorageConfigured,
                skipQueryValidation,
                autoMitigate,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MonitorMetricNamespace"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="classification"> Kind of namespace. </param>
        /// <param name="metricNamespaceNameValue"> Properties which include the fully qualified namespace name. </param>
        /// <returns> A new <see cref="Models.MonitorMetricNamespace"/> instance for mocking. </returns>
        public static MonitorMetricNamespace MonitorMetricNamespace(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, MonitorNamespaceClassification? classification = null, string metricNamespaceNameValue = null)
        {
            return new MonitorMetricNamespace(
                id,
                name,
                resourceType,
                systemData,
                classification,
                metricNamespaceNameValue != null ? new MetricNamespaceName(metricNamespaceNameValue, serializedAdditionalRawData: null) : null,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Monitor.VmInsightsOnboardingStatusData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="resourceId"> Azure Resource Manager identifier of the resource whose onboarding status is being represented. </param>
        /// <param name="onboardingStatus"> The onboarding status for the resource. Note that, a higher level scope, e.g., resource group or subscription, is considered onboarded if at least one resource under it is onboarded. </param>
        /// <param name="dataStatus"> The status of VM Insights data from the resource. When reported as `present` the data array will contain information about the data containers to which data for the specified resource is being routed. </param>
        /// <param name="data"> Containers that currently store VM Insights data for the specified resource. </param>
        /// <returns> A new <see cref="Monitor.VmInsightsOnboardingStatusData"/> instance for mocking. </returns>
        public static VmInsightsOnboardingStatusData VmInsightsOnboardingStatusData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ResourceIdentifier resourceId = null, OnboardingStatus? onboardingStatus = null, DataStatus? dataStatus = null, IEnumerable<DataContainer> data = null)
        {
            data ??= new List<DataContainer>();

            return new VmInsightsOnboardingStatusData(
                id,
                name,
                resourceType,
                systemData,
                resourceId,
                onboardingStatus,
                dataStatus,
                data?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataContainer"/>. </summary>
        /// <param name="workspace"> Log Analytics workspace information. </param>
        /// <returns> A new <see cref="Models.DataContainer"/> instance for mocking. </returns>
        public static DataContainer DataContainer(DataContainerWorkspace workspace = null)
        {
            return new DataContainer(workspace, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataContainerWorkspace"/>. </summary>
        /// <param name="id"> Azure Resource Manager identifier of the Log Analytics Workspace. </param>
        /// <param name="location"> Location of the Log Analytics workspace. </param>
        /// <param name="customerId"> Log Analytics workspace identifier. </param>
        /// <returns> A new <see cref="Models.DataContainerWorkspace"/> instance for mocking. </returns>
        public static DataContainerWorkspace DataContainerWorkspace(ResourceIdentifier id = null, AzureLocation location = default, string customerId = null)
        {
            return new DataContainerWorkspace(id, location, customerId, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Monitor.MonitorPrivateLinkScopeData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="provisioningState"> Current state of this PrivateLinkScope: whether or not is has been provisioned within the resource group it is defined. Users cannot change this value but are able to read from it. Values will include Provisioning ,Succeeded, Canceled and Failed. </param>
        /// <param name="privateEndpointConnections"> List of private endpoint connections. </param>
        /// <param name="accessModeSettings"> Access mode settings. </param>
        /// <returns> A new <see cref="Monitor.MonitorPrivateLinkScopeData"/> instance for mocking. </returns>
        public static MonitorPrivateLinkScopeData MonitorPrivateLinkScopeData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, string provisioningState = null, IEnumerable<MonitorPrivateEndpointConnectionData> privateEndpointConnections = null, MonitorPrivateLinkAccessModeSettings accessModeSettings = null)
        {
            tags ??= new Dictionary<string, string>();
            privateEndpointConnections ??= new List<MonitorPrivateEndpointConnectionData>();

            return new MonitorPrivateLinkScopeData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                provisioningState,
                privateEndpointConnections?.ToList(),
                accessModeSettings,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Monitor.MonitorPrivateEndpointConnectionData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="privateEndpointId"> The resource of private end point. </param>
        /// <param name="connectionState"> A collection of information about the state of the connection between service consumer and provider. </param>
        /// <param name="provisioningState"> The provisioning state of the private endpoint connection resource. </param>
        /// <returns> A new <see cref="Monitor.MonitorPrivateEndpointConnectionData"/> instance for mocking. </returns>
        public static MonitorPrivateEndpointConnectionData MonitorPrivateEndpointConnectionData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ResourceIdentifier privateEndpointId = null, MonitorPrivateLinkServiceConnectionState connectionState = null, MonitorPrivateEndpointConnectionProvisioningState? provisioningState = null)
        {
            return new MonitorPrivateEndpointConnectionData(
                id,
                name,
                resourceType,
                systemData,
                privateEndpointId != null ? ResourceManagerModelFactory.SubResource(privateEndpointId) : null,
                connectionState,
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MonitorPrivateLinkScopeOperationStatus"/>. </summary>
        /// <param name="id"> The operation Id. </param>
        /// <param name="name"> The operation name. </param>
        /// <param name="startOn"> Start time of the job in standard ISO8601 format. </param>
        /// <param name="endOn"> End time of the job in standard ISO8601 format. </param>
        /// <param name="status"> The status of the operation. </param>
        /// <param name="error"> The error detail of the operation if any. </param>
        /// <returns> A new <see cref="Models.MonitorPrivateLinkScopeOperationStatus"/> instance for mocking. </returns>
        public static MonitorPrivateLinkScopeOperationStatus MonitorPrivateLinkScopeOperationStatus(string id = null, string name = null, DateTimeOffset? startOn = null, DateTimeOffset? endOn = null, string status = null, ResponseError error = null)
        {
            return new MonitorPrivateLinkScopeOperationStatus(
                id,
                name,
                startOn,
                endOn,
                status,
                error,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Monitor.MonitorPrivateLinkResourceData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="groupId"> The private link resource group id. </param>
        /// <param name="requiredMembers"> The private link resource required member names. </param>
        /// <param name="requiredZoneNames"> The private link resource Private link DNS zone name. </param>
        /// <returns> A new <see cref="Monitor.MonitorPrivateLinkResourceData"/> instance for mocking. </returns>
        public static MonitorPrivateLinkResourceData MonitorPrivateLinkResourceData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, string groupId = null, IEnumerable<string> requiredMembers = null, IEnumerable<string> requiredZoneNames = null)
        {
            requiredMembers ??= new List<string>();
            requiredZoneNames ??= new List<string>();

            return new MonitorPrivateLinkResourceData(
                id,
                name,
                resourceType,
                systemData,
                groupId,
                requiredMembers?.ToList(),
                requiredZoneNames?.ToList(),
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Monitor.MonitorPrivateLinkScopedResourceData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="linkedResourceId"> The resource id of the scoped Azure monitor resource. </param>
        /// <param name="provisioningState"> State of the private endpoint connection. </param>
        /// <returns> A new <see cref="Monitor.MonitorPrivateLinkScopedResourceData"/> instance for mocking. </returns>
        public static MonitorPrivateLinkScopedResourceData MonitorPrivateLinkScopedResourceData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ResourceIdentifier linkedResourceId = null, string provisioningState = null)
        {
            return new MonitorPrivateLinkScopedResourceData(
                id,
                name,
                resourceType,
                systemData,
                linkedResourceId,
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Monitor.ActivityLogAlertData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="scopes"> A list of resource IDs that will be used as prefixes. The alert will only apply to Activity Log events with resource IDs that fall under one of these prefixes. This list must include at least one item. </param>
        /// <param name="conditionAllOf"> The condition that will cause this alert to activate. </param>
        /// <param name="actionsActionGroups"> The actions that will activate when the condition is met. </param>
        /// <param name="isEnabled"> Indicates whether this Activity Log Alert rule is enabled. If an Activity Log Alert rule is not enabled, then none of its actions will be activated. </param>
        /// <param name="description"> A description of this Activity Log Alert rule. </param>
        /// <returns> A new <see cref="Monitor.ActivityLogAlertData"/> instance for mocking. </returns>
        public static ActivityLogAlertData ActivityLogAlertData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, IEnumerable<string> scopes = null, IEnumerable<ActivityLogAlertAnyOfOrLeafCondition> conditionAllOf = null, IEnumerable<ActivityLogAlertActionGroup> actionsActionGroups = null, bool? isEnabled = null, string description = null)
        {
            tags ??= new Dictionary<string, string>();
            scopes ??= new List<string>();
            conditionAllOf ??= new List<ActivityLogAlertAnyOfOrLeafCondition>();
            actionsActionGroups ??= new List<ActivityLogAlertActionGroup>();

            return new ActivityLogAlertData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                scopes?.ToList(),
                conditionAllOf != null ? new AlertRuleAllOfCondition(conditionAllOf?.ToList(), serializedAdditionalRawData: null) : null,
                actionsActionGroups != null ? new ActionList(actionsActionGroups?.ToList(), serializedAdditionalRawData: null) : null,
                isEnabled,
                description,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Monitor.DataCollectionEndpointData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="kind"> The kind of the resource. </param>
        /// <param name="identity"> Managed service identity of the resource. </param>
        /// <param name="etag"> Resource entity tag (ETag). </param>
        /// <param name="description"> Description of the data collection endpoint. </param>
        /// <param name="immutableId"> The immutable ID of this data collection endpoint resource. This property is READ-ONLY. </param>
        /// <param name="configurationAccessEndpoint"> The endpoint used by clients to access their configuration. </param>
        /// <param name="logsIngestionEndpoint"> The endpoint used by clients to ingest logs. </param>
        /// <param name="metricsIngestionEndpoint"> The endpoint used by clients to ingest metrics. </param>
        /// <param name="publicNetworkAccess"> Network access control rules for the endpoints. </param>
        /// <param name="provisioningState"> The resource provisioning state. This property is READ-ONLY. </param>
        /// <param name="privateLinkScopedResources"> List of Azure Monitor Private Link Scope Resources to which this data collection endpoint resource is associated. This property is READ-ONLY. </param>
        /// <param name="failoverConfiguration"> Failover configuration on this endpoint. This property is READ-ONLY. </param>
        /// <param name="metadata"> Metadata for the resource. This property is READ-ONLY. </param>
        /// <returns> A new <see cref="Monitor.DataCollectionEndpointData"/> instance for mocking. </returns>
        public static DataCollectionEndpointData DataCollectionEndpointData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, DataCollectionEndpointResourceKind? kind = null, ManagedServiceIdentity identity = null, ETag? etag = null, string description = null, string immutableId = null, string configurationAccessEndpoint = null, string logsIngestionEndpoint = null, string metricsIngestionEndpoint = null, MonitorPublicNetworkAccess? publicNetworkAccess = null, DataCollectionEndpointProvisioningState? provisioningState = null, IEnumerable<DataCollectionRulePrivateLinkScopedResourceInfo> privateLinkScopedResources = null, DataCollectionEndpointFailoverConfiguration failoverConfiguration = null, DataCollectionEndpointMetadata metadata = null)
        {
            tags ??= new Dictionary<string, string>();
            privateLinkScopedResources ??= new List<DataCollectionRulePrivateLinkScopedResourceInfo>();

            return new DataCollectionEndpointData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                kind,
                identity,
                etag,
                description,
                immutableId,
                configurationAccessEndpoint != null ? new DataCollectionEndpointConfigurationAccess(configurationAccessEndpoint, serializedAdditionalRawData: null) : null,
                logsIngestionEndpoint != null ? new DataCollectionEndpointLogsIngestion(logsIngestionEndpoint, serializedAdditionalRawData: null) : null,
                metricsIngestionEndpoint != null ? new DataCollectionEndpointMetricsIngestion(metricsIngestionEndpoint, serializedAdditionalRawData: null) : null,
                publicNetworkAccess != null ? new DataCollectionEndpointNetworkAcls(publicNetworkAccess, serializedAdditionalRawData: null) : null,
                provisioningState,
                privateLinkScopedResources?.ToList(),
                failoverConfiguration,
                metadata,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataCollectionRulePrivateLinkScopedResourceInfo"/>. </summary>
        /// <param name="resourceId"> The resourceId of the Azure Monitor Private Link Scope Scoped Resource through which this DCE is associated with a Azure Monitor Private Link Scope. </param>
        /// <param name="scopeId"> The immutableId of the Azure Monitor Private Link Scope Resource to which the association is. </param>
        /// <returns> A new <see cref="Models.DataCollectionRulePrivateLinkScopedResourceInfo"/> instance for mocking. </returns>
        public static DataCollectionRulePrivateLinkScopedResourceInfo DataCollectionRulePrivateLinkScopedResourceInfo(ResourceIdentifier resourceId = null, string scopeId = null)
        {
            return new DataCollectionRulePrivateLinkScopedResourceInfo(resourceId, scopeId, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataCollectionEndpointFailoverConfiguration"/>. </summary>
        /// <param name="activeLocation"> Active location where data flow will occur. </param>
        /// <param name="locations"> Locations that are configured for failover. </param>
        /// <returns> A new <see cref="Models.DataCollectionEndpointFailoverConfiguration"/> instance for mocking. </returns>
        public static DataCollectionEndpointFailoverConfiguration DataCollectionEndpointFailoverConfiguration(string activeLocation = null, IEnumerable<DataCollectionRuleBcdrLocationSpec> locations = null)
        {
            locations ??= new List<DataCollectionRuleBcdrLocationSpec>();

            return new DataCollectionEndpointFailoverConfiguration(activeLocation, locations?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataCollectionRuleBcdrFailoverConfigurationSpec"/>. </summary>
        /// <param name="activeLocation"> Active location where data flow will occur. </param>
        /// <param name="locations"> Locations that are configured for failover. </param>
        /// <returns> A new <see cref="Models.DataCollectionRuleBcdrFailoverConfigurationSpec"/> instance for mocking. </returns>
        public static DataCollectionRuleBcdrFailoverConfigurationSpec DataCollectionRuleBcdrFailoverConfigurationSpec(string activeLocation = null, IEnumerable<DataCollectionRuleBcdrLocationSpec> locations = null)
        {
            locations ??= new List<DataCollectionRuleBcdrLocationSpec>();

            return new DataCollectionRuleBcdrFailoverConfigurationSpec(activeLocation, locations?.ToList(), serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataCollectionRuleBcdrLocationSpec"/>. </summary>
        /// <param name="location"> Name of location. </param>
        /// <param name="provisioningStatus"> The resource provisioning state in this location. </param>
        /// <returns> A new <see cref="Models.DataCollectionRuleBcdrLocationSpec"/> instance for mocking. </returns>
        public static DataCollectionRuleBcdrLocationSpec DataCollectionRuleBcdrLocationSpec(AzureLocation? location = null, DataCollectionRuleBcdrLocationSpecProvisioningStatus? provisioningStatus = null)
        {
            return new DataCollectionRuleBcdrLocationSpec(location, provisioningStatus, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataCollectionEndpointMetadata"/>. </summary>
        /// <param name="provisionedBy"> Azure offering managing this resource on-behalf-of customer. </param>
        /// <param name="provisionedByResourceId"> Resource Id of azure offering managing this resource on-behalf-of customer. </param>
        /// <returns> A new <see cref="Models.DataCollectionEndpointMetadata"/> instance for mocking. </returns>
        public static DataCollectionEndpointMetadata DataCollectionEndpointMetadata(string provisionedBy = null, string provisionedByResourceId = null)
        {
            return new DataCollectionEndpointMetadata(provisionedBy, provisionedByResourceId, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataCollectionRuleRelatedResourceMetadata"/>. </summary>
        /// <param name="provisionedBy"> Azure offering managing this resource on-behalf-of customer. </param>
        /// <param name="provisionedByResourceId"> Resource Id of azure offering managing this resource on-behalf-of customer. </param>
        /// <returns> A new <see cref="Models.DataCollectionRuleRelatedResourceMetadata"/> instance for mocking. </returns>
        public static DataCollectionRuleRelatedResourceMetadata DataCollectionRuleRelatedResourceMetadata(string provisionedBy = null, string provisionedByResourceId = null)
        {
            return new DataCollectionRuleRelatedResourceMetadata(provisionedBy, provisionedByResourceId, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Monitor.DataCollectionRuleAssociationData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="etag"> Resource entity tag (ETag). </param>
        /// <param name="description"> Description of the association. </param>
        /// <param name="dataCollectionRuleId"> The resource ID of the data collection rule that is to be associated. </param>
        /// <param name="dataCollectionEndpointId"> The resource ID of the data collection endpoint that is to be associated. </param>
        /// <param name="provisioningState"> The resource provisioning state. </param>
        /// <param name="metadata"> Metadata about the resource. </param>
        /// <returns> A new <see cref="Monitor.DataCollectionRuleAssociationData"/> instance for mocking. </returns>
        public static DataCollectionRuleAssociationData DataCollectionRuleAssociationData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, ETag? etag = null, string description = null, ResourceIdentifier dataCollectionRuleId = null, ResourceIdentifier dataCollectionEndpointId = null, DataCollectionRuleAssociationProvisioningState? provisioningState = null, DataCollectionRuleAssociationMetadata metadata = null)
        {
            return new DataCollectionRuleAssociationData(
                id,
                name,
                resourceType,
                systemData,
                etag,
                description,
                dataCollectionRuleId,
                dataCollectionEndpointId,
                provisioningState,
                metadata,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataCollectionRuleAssociationMetadata"/>. </summary>
        /// <param name="provisionedBy"> Azure offering managing this resource on-behalf-of customer. </param>
        /// <param name="provisionedByResourceId"> Resource Id of azure offering managing this resource on-behalf-of customer. </param>
        /// <returns> A new <see cref="Models.DataCollectionRuleAssociationMetadata"/> instance for mocking. </returns>
        public static DataCollectionRuleAssociationMetadata DataCollectionRuleAssociationMetadata(string provisionedBy = null, string provisionedByResourceId = null)
        {
            return new DataCollectionRuleAssociationMetadata(provisionedBy, provisionedByResourceId, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Monitor.DataCollectionRuleData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="kind"> The kind of the resource. </param>
        /// <param name="identity"> Managed service identity of the resource. </param>
        /// <param name="etag"> Resource entity tag (ETag). </param>
        /// <param name="description"> Description of the data collection rule. </param>
        /// <param name="immutableId"> The immutable ID of this data collection rule. This property is READ-ONLY. </param>
        /// <param name="dataCollectionEndpointId"> The resource ID of the data collection endpoint that this rule can be used with. </param>
        /// <param name="metadata"> Metadata about the resource. </param>
        /// <param name="streamDeclarations"> Declaration of custom streams used in this rule. </param>
        /// <param name="dataSources">
        /// The specification of data sources.
        /// This property is optional and can be omitted if the rule is meant to be used via direct calls to the provisioned endpoint.
        /// </param>
        /// <param name="destinations"> The specification of destinations. </param>
        /// <param name="dataFlows"> The specification of data flows. </param>
        /// <param name="provisioningState"> The resource provisioning state. </param>
        /// <returns> A new <see cref="Monitor.DataCollectionRuleData"/> instance for mocking. </returns>
        public static DataCollectionRuleData DataCollectionRuleData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, DataCollectionRuleResourceKind? kind = null, ManagedServiceIdentity identity = null, ETag? etag = null, string description = null, string immutableId = null, ResourceIdentifier dataCollectionEndpointId = null, DataCollectionRuleMetadata metadata = null, IDictionary<string, DataStreamDeclaration> streamDeclarations = null, DataCollectionRuleDataSources dataSources = null, DataCollectionRuleDestinations destinations = null, IEnumerable<DataFlow> dataFlows = null, DataCollectionRuleProvisioningState? provisioningState = null)
        {
            tags ??= new Dictionary<string, string>();
            streamDeclarations ??= new Dictionary<string, DataStreamDeclaration>();
            dataFlows ??= new List<DataFlow>();

            return new DataCollectionRuleData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                kind,
                identity,
                etag,
                description,
                immutableId,
                dataCollectionEndpointId,
                metadata,
                streamDeclarations,
                dataSources,
                destinations,
                dataFlows?.ToList(),
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.DataCollectionRuleMetadata"/>. </summary>
        /// <param name="provisionedBy"> Azure offering managing this resource on-behalf-of customer. </param>
        /// <param name="provisionedByResourceId"> Resource Id of azure offering managing this resource on-behalf-of customer. </param>
        /// <returns> A new <see cref="Models.DataCollectionRuleMetadata"/> instance for mocking. </returns>
        public static DataCollectionRuleMetadata DataCollectionRuleMetadata(string provisionedBy = null, string provisionedByResourceId = null)
        {
            return new DataCollectionRuleMetadata(provisionedBy, provisionedByResourceId, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.LogAnalyticsDestination"/>. </summary>
        /// <param name="workspaceResourceId"> The resource ID of the Log Analytics workspace. </param>
        /// <param name="workspaceId"> The Customer ID of the Log Analytics workspace. </param>
        /// <param name="name">
        /// A friendly name for the destination.
        /// This name should be unique across all destinations (regardless of type) within the data collection rule.
        /// </param>
        /// <returns> A new <see cref="Models.LogAnalyticsDestination"/> instance for mocking. </returns>
        public static LogAnalyticsDestination LogAnalyticsDestination(ResourceIdentifier workspaceResourceId = null, string workspaceId = null, string name = null)
        {
            return new LogAnalyticsDestination(workspaceResourceId, workspaceId, name, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MonitoringAccountDestination"/>. </summary>
        /// <param name="accountResourceId"> The resource ID of the monitoring account. </param>
        /// <param name="accountId"> The immutable ID  of the account. </param>
        /// <param name="name">
        /// A friendly name for the destination.
        /// This name should be unique across all destinations (regardless of type) within the data collection rule.
        /// </param>
        /// <returns> A new <see cref="Models.MonitoringAccountDestination"/> instance for mocking. </returns>
        public static MonitoringAccountDestination MonitoringAccountDestination(ResourceIdentifier accountResourceId = null, string accountId = null, string name = null)
        {
            return new MonitoringAccountDestination(accountResourceId, accountId, name, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Monitor.MonitorWorkspaceResourceData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="etag"> Resource entity tag (ETag). </param>
        /// <param name="defaultIngestionSettings"> The Data Collection Rule and Endpoint used for ingestion by default. </param>
        /// <param name="metrics"> Properties related to the metrics container in the Azure Monitor Workspace. </param>
        /// <param name="accountId"> The immutable ID of the Azure Monitor workspace. This property is read-only. </param>
        /// <param name="metricsPropertiesMetrics"> Information about metrics for the Azure Monitor workspace. </param>
        /// <param name="provisioningState"> The provisioning state of the Azure Monitor workspace. Set to Succeeded if everything is healthy. </param>
        /// <param name="defaultIngestionSettingsPropertiesDefaultIngestionSettings"> The Data Collection Rule and Endpoint used for ingestion by default. </param>
        /// <param name="privateEndpointConnections"> List of private endpoint connections. </param>
        /// <param name="publicNetworkAccess"> Gets or sets allow or disallow public network access to workspace. </param>
        /// <returns> A new <see cref="Monitor.MonitorWorkspaceResourceData"/> instance for mocking. </returns>
        public static MonitorWorkspaceResourceData MonitorWorkspaceResourceData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, ETag? etag = null, MonitorWorkspaceDefaultIngestionSettings defaultIngestionSettings = null, MonitorWorkspaceMetrics metrics = null, string accountId = null, MonitorWorkspaceMetricProperties metricsPropertiesMetrics = null, MonitorProvisioningState? provisioningState = null, MonitorWorkspaceIngestionSettings defaultIngestionSettingsPropertiesDefaultIngestionSettings = null, IEnumerable<MonitorWorkspacePrivateEndpointConnection> privateEndpointConnections = null, MonitorWorkspacePublicNetworkAccess? publicNetworkAccess = null)
        {
            tags ??= new Dictionary<string, string>();
            privateEndpointConnections ??= new List<MonitorWorkspacePrivateEndpointConnection>();

            return new MonitorWorkspaceResourceData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                etag,
                defaultIngestionSettings,
                metrics,
                accountId,
                metricsPropertiesMetrics,
                provisioningState,
                defaultIngestionSettingsPropertiesDefaultIngestionSettings,
                privateEndpointConnections?.ToList(),
                publicNetworkAccess,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MonitorWorkspaceMetricProperties"/>. </summary>
        /// <param name="prometheusQueryEndpoint"> The Prometheus query endpoint for the workspace. </param>
        /// <param name="internalId"> An internal identifier for the metrics container. Only to be used by the system. </param>
        /// <returns> A new <see cref="Models.MonitorWorkspaceMetricProperties"/> instance for mocking. </returns>
        public static MonitorWorkspaceMetricProperties MonitorWorkspaceMetricProperties(string prometheusQueryEndpoint = null, string internalId = null)
        {
            return new MonitorWorkspaceMetricProperties(prometheusQueryEndpoint, internalId, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MonitorWorkspaceIngestionSettings"/>. </summary>
        /// <param name="dataCollectionRuleResourceId"> The Azure resource Id of the default data collection rule for this workspace. </param>
        /// <param name="dataCollectionEndpointResourceId"> The Azure resource Id of the default data collection endpoint for this workspace. </param>
        /// <returns> A new <see cref="Models.MonitorWorkspaceIngestionSettings"/> instance for mocking. </returns>
        public static MonitorWorkspaceIngestionSettings MonitorWorkspaceIngestionSettings(ResourceIdentifier dataCollectionRuleResourceId = null, ResourceIdentifier dataCollectionEndpointResourceId = null)
        {
            return new MonitorWorkspaceIngestionSettings(dataCollectionRuleResourceId, dataCollectionEndpointResourceId, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MonitorWorkspacePrivateEndpointConnection"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="groupIds"> The group ids for the private endpoint resource. </param>
        /// <param name="privateEndpointId"> The private endpoint resource. </param>
        /// <param name="connectionState"> A collection of information about the state of the connection between service consumer and provider. </param>
        /// <param name="provisioningState"> The provisioning state of the private endpoint connection resource. </param>
        /// <returns> A new <see cref="Models.MonitorWorkspacePrivateEndpointConnection"/> instance for mocking. </returns>
        public static MonitorWorkspacePrivateEndpointConnection MonitorWorkspacePrivateEndpointConnection(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IEnumerable<string> groupIds = null, ResourceIdentifier privateEndpointId = null, MonitorPrivateLinkServiceConnectionState connectionState = null, MonitorPrivateEndpointConnectionProvisioningState? provisioningState = null)
        {
            groupIds ??= new List<string>();

            return new MonitorWorkspacePrivateEndpointConnection(
                id,
                name,
                resourceType,
                systemData,
                groupIds?.ToList(),
                privateEndpointId != null ? ResourceManagerModelFactory.SubResource(privateEndpointId) : null,
                connectionState,
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MonitorWorkspaceDefaultIngestionSettings"/>. </summary>
        /// <param name="dataCollectionRuleResourceId"> The Azure resource Id of the default data collection rule for this workspace. </param>
        /// <param name="dataCollectionEndpointResourceId"> The Azure resource Id of the default data collection endpoint for this workspace. </param>
        /// <returns> A new <see cref="Models.MonitorWorkspaceDefaultIngestionSettings"/> instance for mocking. </returns>
        public static MonitorWorkspaceDefaultIngestionSettings MonitorWorkspaceDefaultIngestionSettings(ResourceIdentifier dataCollectionRuleResourceId = null, ResourceIdentifier dataCollectionEndpointResourceId = null)
        {
            return new MonitorWorkspaceDefaultIngestionSettings(dataCollectionRuleResourceId, dataCollectionEndpointResourceId, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MonitorWorkspaceMetrics"/>. </summary>
        /// <param name="prometheusQueryEndpoint"> The Prometheus query endpoint for the workspace. </param>
        /// <param name="internalId"> An internal identifier for the metrics container. Only to be used by the system. </param>
        /// <returns> A new <see cref="Models.MonitorWorkspaceMetrics"/> instance for mocking. </returns>
        public static MonitorWorkspaceMetrics MonitorWorkspaceMetrics(string prometheusQueryEndpoint = null, string internalId = null)
        {
            return new MonitorWorkspaceMetrics(prometheusQueryEndpoint, internalId, serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="Monitor.PipelineGroupData"/>. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="extendedLocation"> The extended location for given pipeline group. </param>
        /// <param name="replicas"> Defines the amount of replicas of the pipeline group instance. </param>
        /// <param name="receivers"> The receivers specified for a pipeline group instance. </param>
        /// <param name="processors"> The processors specified for a pipeline group instance. </param>
        /// <param name="exporters"> The exporters specified for a pipeline group instance. </param>
        /// <param name="service"> The service section for a given pipeline group instance. </param>
        /// <param name="networkingConfigurations"> Networking configurations for the pipeline group instance. </param>
        /// <param name="provisioningState"> The provisioning state of a pipeline group instance. Set to Succeeded if everything is healthy. </param>
        /// <returns> A new <see cref="Monitor.PipelineGroupData"/> instance for mocking. </returns>
        public static PipelineGroupData PipelineGroupData(ResourceIdentifier id = null, string name = null, ResourceType resourceType = default, SystemData systemData = null, IDictionary<string, string> tags = null, AzureLocation location = default, ExtendedLocation extendedLocation = null, int? replicas = null, IEnumerable<PipelineGroupReceiver> receivers = null, IEnumerable<PipelineGroupProcessor> processors = null, IEnumerable<PipelineGroupExporter> exporters = null, PipelineGroupService service = null, IEnumerable<PipelineGroupNetworkingConfiguration> networkingConfigurations = null, MonitorProvisioningState? provisioningState = null)
        {
            tags ??= new Dictionary<string, string>();
            receivers ??= new List<PipelineGroupReceiver>();
            processors ??= new List<PipelineGroupProcessor>();
            exporters ??= new List<PipelineGroupExporter>();
            networkingConfigurations ??= new List<PipelineGroupNetworkingConfiguration>();

            return new PipelineGroupData(
                id,
                name,
                resourceType,
                systemData,
                tags,
                location,
                extendedLocation,
                replicas,
                receivers?.ToList(),
                processors?.ToList(),
                exporters?.ToList(),
                service,
                networkingConfigurations?.ToList(),
                provisioningState,
                serializedAdditionalRawData: null);
        }

        /// <summary> Initializes a new instance of <see cref="T:Azure.ResourceManager.Monitor.MonitorWorkspaceResourceData" />. </summary>
        /// <param name="id"> The id. </param>
        /// <param name="name"> The name. </param>
        /// <param name="resourceType"> The resourceType. </param>
        /// <param name="systemData"> The systemData. </param>
        /// <param name="tags"> The tags. </param>
        /// <param name="location"> The location. </param>
        /// <param name="etag"> Resource entity tag (ETag). </param>
        /// <param name="accountId"> The immutable ID of the Azure Monitor workspace. This property is read-only. </param>
        /// <param name="metrics"> Information about metrics for the Azure Monitor workspace. </param>
        /// <param name="provisioningState"> The provisioning state of the Azure Monitor workspace. Set to Succeeded if everything is healthy. </param>
        /// <param name="defaultIngestionSettings"> The Data Collection Rule and Endpoint used for ingestion by default. </param>
        /// <param name="privateEndpointConnections"> List of private endpoint connections. </param>
        /// <param name="publicNetworkAccess"> Gets or sets allow or disallow public network access to workspace. </param>
        /// <returns> A new <see cref="T:Azure.ResourceManager.Monitor.MonitorWorkspaceResourceData" /> instance for mocking. </returns>
        [EditorBrowsable(EditorBrowsableState.Never)]
        public static MonitorWorkspaceResourceData MonitorWorkspaceResourceData(ResourceIdentifier id, string name, ResourceType resourceType, SystemData systemData, IDictionary<string, string> tags, AzureLocation location, ETag? etag, string accountId, MonitorWorkspaceMetrics metrics, MonitorProvisioningState? provisioningState, MonitorWorkspaceDefaultIngestionSettings defaultIngestionSettings, IEnumerable<MonitorWorkspacePrivateEndpointConnection> privateEndpointConnections, MonitorWorkspacePublicNetworkAccess? publicNetworkAccess)
        {
            return MonitorWorkspaceResourceData(id: id, name: name, resourceType: resourceType, systemData: systemData, tags: tags, location: location, etag: etag, defaultIngestionSettings: defaultIngestionSettings, metrics: metrics, accountId: accountId, metricsPropertiesMetrics: default, provisioningState: provisioningState, defaultIngestionSettingsPropertiesDefaultIngestionSettings: default, privateEndpointConnections: privateEndpointConnections, publicNetworkAccess: publicNetworkAccess);
        }
    }
}
