// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using System.Xml;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Monitor.Models;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.Monitor.Samples
{
    public partial class Sample_SubscriptionResourceExtensions
    {
        // Get Activity Logs with filter
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetActivityLogs_GetActivityLogsWithFilter()
        {
            // Generated from example definition: specification/monitor/resource-manager/Microsoft.Insights/stable/2015-04-01/examples/GetActivityLogsFiltered.json
            // this example is just showing the usage of "ActivityLogs_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionResource created on azure
            // for more information of creating SubscriptionResource, please refer to the document of SubscriptionResource
            string subscriptionId = "089bd33f-d4ec-47fe-8ba5-0753aa5c5b33";
            ResourceIdentifier subscriptionResourceId = SubscriptionResource.CreateResourceIdentifier(subscriptionId);
            SubscriptionResource subscriptionResource = client.GetSubscriptionResource(subscriptionResourceId);

            // invoke the operation and iterate over the result
            string filter = "eventTimestamp ge '2015-01-21T20:00:00Z' and eventTimestamp le '2015-01-23T20:00:00Z' and resourceGroupName eq 'MSSupportGroup'";
            await foreach (EventDataInfo item in subscriptionResource.GetActivityLogsAsync(filter))
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }

        // Get Activity Logs with filter and select
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetActivityLogs_GetActivityLogsWithFilterAndSelect()
        {
            // Generated from example definition: specification/monitor/resource-manager/Microsoft.Insights/stable/2015-04-01/examples/GetActivityLogsFilteredAndSelected.json
            // this example is just showing the usage of "ActivityLogs_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionResource created on azure
            // for more information of creating SubscriptionResource, please refer to the document of SubscriptionResource
            string subscriptionId = "089bd33f-d4ec-47fe-8ba5-0753aa5c5b33";
            ResourceIdentifier subscriptionResourceId = SubscriptionResource.CreateResourceIdentifier(subscriptionId);
            SubscriptionResource subscriptionResource = client.GetSubscriptionResource(subscriptionResourceId);

            // invoke the operation and iterate over the result
            string filter = "eventTimestamp ge '2015-01-21T20:00:00Z' and eventTimestamp le '2015-01-23T20:00:00Z' and resourceGroupName eq 'MSSupportGroup'";
            string select = "eventName,id,resourceGroupName,resourceProviderName,operationName,status,eventTimestamp,correlationId,submissionTimestamp,level";
            await foreach (EventDataInfo item in subscriptionResource.GetActivityLogsAsync(filter, select: select))
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }

        // Get subscription level metric data
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetMonitorMetrics_GetSubscriptionLevelMetricData()
        {
            // Generated from example definition: specification/monitor/resource-manager/Microsoft.Insights/stable/2021-05-01/examples/GetMultiResourceMetric.json
            // this example is just showing the usage of "Metrics_ListAtSubscriptionScope" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionResource created on azure
            // for more information of creating SubscriptionResource, please refer to the document of SubscriptionResource
            string subscriptionId = "92d2a2d8-b514-432d-8cc9-a5f9272630d5";
            ResourceIdentifier subscriptionResourceId = SubscriptionResource.CreateResourceIdentifier(subscriptionId);
            SubscriptionResource subscriptionResource = client.GetSubscriptionResource(subscriptionResourceId);

            // invoke the operation and iterate over the result
            SubscriptionResourceGetMonitorMetricsOptions options = new SubscriptionResourceGetMonitorMetricsOptions(region: "westus2") { Timespan = "2021-06-08T19:00:00Z/2021-06-12T01:00:00Z", Interval = XmlConvert.ToTimeSpan("PT6H"), Metricnames = "Data Disk Max Burst IOPS", Aggregation = "count", Top = 10, Orderby = "count desc", Filter = "LUN eq '0' and Microsoft.ResourceId eq '*'", Metricnamespace = "microsoft.compute/virtualmachines", AutoAdjustTimegrain = true, ValidateDimensions = false };
            await foreach (SubscriptionMonitorMetric item in subscriptionResource.GetMonitorMetricsAsync(options))
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }

        // Get subscription level metric metadata
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetMonitorMetrics_GetSubscriptionLevelMetricMetadata()
        {
            // Generated from example definition: specification/monitor/resource-manager/Microsoft.Insights/stable/2021-05-01/examples/GetMultiResourceMetricMetadata.json
            // this example is just showing the usage of "Metrics_ListAtSubscriptionScope" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionResource created on azure
            // for more information of creating SubscriptionResource, please refer to the document of SubscriptionResource
            string subscriptionId = "92d2a2d8-b514-432d-8cc9-a5f9272630d5";
            ResourceIdentifier subscriptionResourceId = SubscriptionResource.CreateResourceIdentifier(subscriptionId);
            SubscriptionResource subscriptionResource = client.GetSubscriptionResource(subscriptionResourceId);

            // invoke the operation and iterate over the result
            SubscriptionResourceGetMonitorMetricsOptions options = new SubscriptionResourceGetMonitorMetricsOptions(region: "westus2") { Timespan = "2021-06-10T02:23:16.129Z/2021-06-12T02:23:16.129Z", Metricnames = "Data Disk Max Burst IOPS", Filter = "LUN eq '0'", Metricnamespace = "microsoft.compute/virtualmachines" };
            await foreach (SubscriptionMonitorMetric item in subscriptionResource.GetMonitorMetricsAsync(options))
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }

        // Post request for subscription level metric data
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetMonitorMetricsWithPost_PostRequestForSubscriptionLevelMetricData()
        {
            // Generated from example definition: specification/monitor/resource-manager/Microsoft.Insights/stable/2021-05-01/examples/GetMultiResourceMetric.json
            // this example is just showing the usage of "Metrics_ListAtSubscriptionScopePost" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionResource created on azure
            // for more information of creating SubscriptionResource, please refer to the document of SubscriptionResource
            string subscriptionId = "92d2a2d8-b514-432d-8cc9-a5f9272630d5";
            ResourceIdentifier subscriptionResourceId = SubscriptionResource.CreateResourceIdentifier(subscriptionId);
            SubscriptionResource subscriptionResource = client.GetSubscriptionResource(subscriptionResourceId);

            // invoke the operation and iterate over the result
            SubscriptionResourceGetMonitorMetricsWithPostOptions options = new SubscriptionResourceGetMonitorMetricsWithPostOptions(region: "westus2") { Timespan = "2021-06-08T19:00:00Z/2021-06-12T01:00:00Z", Interval = XmlConvert.ToTimeSpan("PT6H"), Metricnames = "Data Disk Max Burst IOPS", Aggregation = "count", Top = 10, Orderby = "count desc", Filter = "LUN eq '0' and Microsoft.ResourceId eq '*'", Metricnamespace = "microsoft.compute/virtualmachines", AutoAdjustTimegrain = true, ValidateDimensions = false };
            await foreach (SubscriptionMonitorMetric item in subscriptionResource.GetMonitorMetricsWithPostAsync(options))
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }

        // Post request for subscription level metric data using body params
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetMonitorMetricsWithPost_PostRequestForSubscriptionLevelMetricDataUsingBodyParams()
        {
            // Generated from example definition: specification/monitor/resource-manager/Microsoft.Insights/stable/2021-05-01/examples/PostMultiResourceMetricBody.json
            // this example is just showing the usage of "Metrics_ListAtSubscriptionScopePost" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionResource created on azure
            // for more information of creating SubscriptionResource, please refer to the document of SubscriptionResource
            string subscriptionId = "92d2a2d8-b514-432d-8cc9-a5f9272630d5";
            ResourceIdentifier subscriptionResourceId = SubscriptionResource.CreateResourceIdentifier(subscriptionId);
            SubscriptionResource subscriptionResource = client.GetSubscriptionResource(subscriptionResourceId);

            // invoke the operation and iterate over the result
            SubscriptionResourceGetMonitorMetricsWithPostOptions options = new SubscriptionResourceGetMonitorMetricsWithPostOptions(region: "westus2")
            {
                Content = new SubscriptionResourceGetMonitorMetricsWithPostContent()
                {
                    Timespan = TimeSpan.Parse("2021-06-08T19:00:00Z/2021-06-12T01:00:00Z"),
                    Interval = XmlConvert.ToTimeSpan("PT6H"),
                    MetricNames = "Data Disk Max Burst IOPS",
                    Aggregation = "count",
                    Filter = "LUN eq '0' and Microsoft.ResourceId eq '*'",
                    Top = 10,
                    OrderBy = "count desc",
                    RollUpBy = "LUN",
                    MetricNamespace = "microsoft.compute/virtualmachines",
                    AutoAdjustTimegrain = true,
                    ValidateDimensions = false,
                }
            };
            await foreach (SubscriptionMonitorMetric item in subscriptionResource.GetMonitorMetricsWithPostAsync(options))
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }

        // Post request for subscription level metric metadata
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetMonitorMetricsWithPost_PostRequestForSubscriptionLevelMetricMetadata()
        {
            // Generated from example definition: specification/monitor/resource-manager/Microsoft.Insights/stable/2021-05-01/examples/GetMultiResourceMetricMetadata.json
            // this example is just showing the usage of "Metrics_ListAtSubscriptionScopePost" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionResource created on azure
            // for more information of creating SubscriptionResource, please refer to the document of SubscriptionResource
            string subscriptionId = "92d2a2d8-b514-432d-8cc9-a5f9272630d5";
            ResourceIdentifier subscriptionResourceId = SubscriptionResource.CreateResourceIdentifier(subscriptionId);
            SubscriptionResource subscriptionResource = client.GetSubscriptionResource(subscriptionResourceId);

            // invoke the operation and iterate over the result
            SubscriptionResourceGetMonitorMetricsWithPostOptions options = new SubscriptionResourceGetMonitorMetricsWithPostOptions(region: "westus2") { Timespan = "2021-06-10T02:23:16.129Z/2021-06-12T02:23:16.129Z", Metricnames = "Data Disk Max Burst IOPS", Filter = "LUN eq '0'", Metricnamespace = "microsoft.compute/virtualmachines" };
            await foreach (SubscriptionMonitorMetric item in subscriptionResource.GetMonitorMetricsWithPostAsync(options))
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }
    }
}
