// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Monitor.Models;
using Azure.ResourceManager.Resources;
using Azure.ResourceManager.Resources.Models;

namespace Azure.ResourceManager.Monitor.Samples
{
    public partial class Sample_PipelineGroupCollection
    {
        // List Pipeline groups by resource group
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAll_ListPipelineGroupsByResourceGroup()
        {
            // Generated from example definition: specification/monitor/resource-manager/Microsoft.Monitor/preview/2023-10-01-preview/examples/PipelineGroupListByResourceGroup.json
            // this example is just showing the usage of "PipelineGroups_ListByResourceGroup" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this PipelineGroupResource
            PipelineGroupCollection collection = resourceGroupResource.GetPipelineGroups();

            // invoke the operation and iterate over the result
            await foreach (PipelineGroupResource item in collection.GetAllAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                PipelineGroupData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // Retrieves a PipelineGroup instance by name
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_RetrievesAPipelineGroupInstanceByName()
        {
            // Generated from example definition: specification/monitor/resource-manager/Microsoft.Monitor/preview/2023-10-01-preview/examples/PipelineGroupGet.json
            // this example is just showing the usage of "PipelineGroups_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this PipelineGroupResource
            PipelineGroupCollection collection = resourceGroupResource.GetPipelineGroups();

            // invoke the operation
            string pipelineGroupName = "plGroup1";
            PipelineGroupResource result = await collection.GetAsync(pipelineGroupName);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            PipelineGroupData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Retrieves a PipelineGroup instance by name
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Exists_RetrievesAPipelineGroupInstanceByName()
        {
            // Generated from example definition: specification/monitor/resource-manager/Microsoft.Monitor/preview/2023-10-01-preview/examples/PipelineGroupGet.json
            // this example is just showing the usage of "PipelineGroups_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this PipelineGroupResource
            PipelineGroupCollection collection = resourceGroupResource.GetPipelineGroups();

            // invoke the operation
            string pipelineGroupName = "plGroup1";
            bool result = await collection.ExistsAsync(pipelineGroupName);

            Console.WriteLine($"Succeeded: {result}");
        }

        // Retrieves a PipelineGroup instance by name
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetIfExists_RetrievesAPipelineGroupInstanceByName()
        {
            // Generated from example definition: specification/monitor/resource-manager/Microsoft.Monitor/preview/2023-10-01-preview/examples/PipelineGroupGet.json
            // this example is just showing the usage of "PipelineGroups_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this PipelineGroupResource
            PipelineGroupCollection collection = resourceGroupResource.GetPipelineGroups();

            // invoke the operation
            string pipelineGroupName = "plGroup1";
            NullableResponse<PipelineGroupResource> response = await collection.GetIfExistsAsync(pipelineGroupName);
            PipelineGroupResource result = response.HasValue ? response.Value : null;

            if (result == null)
            {
                Console.WriteLine($"Succeeded with null as result");
            }
            else
            {
                // the variable result is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                PipelineGroupData resourceData = result.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }
        }

        // Create a PipelineGroup instance using UDP receiver
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateAPipelineGroupInstanceUsingUDPReceiver()
        {
            // Generated from example definition: specification/monitor/resource-manager/Microsoft.Monitor/preview/2023-10-01-preview/examples/PipelineGroupCreateUdp.json
            // this example is just showing the usage of "PipelineGroups_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this PipelineGroupResource
            PipelineGroupCollection collection = resourceGroupResource.GetPipelineGroups();

            // invoke the operation
            string pipelineGroupName = "plGroup1";
            PipelineGroupData data = new PipelineGroupData(new AzureLocation("eastus2"))
            {
                ExtendedLocation = new ExtendedLocation()
                {
                    Name = "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/microsoft.extendedlocation/customlocations/myTestCustomLocation",
                },
                Receivers =
{
new PipelineGroupReceiver(PipelineGroupReceiverType.Udp,"udp-receiver1")
{
Udp = new UdpReceiver("0.0.0.0:518")
{
Encoding = StreamEncodingType.Utf8,
},
}
},
                Processors =
{
},
                Exporters =
{
new PipelineGroupExporter(PipelineGroupExporterType.AzureMonitorWorkspaceLogs,"my-workspace-logs-exporter1")
{
AzureMonitorWorkspaceLogs = new MonitorWorkspaceLogsExporter(new MonitorWorkspaceLogsApiConfig(new Uri("https://logs-myingestion-eb0s.eastus-1.ingest.monitor.azure.com"),"Custom-MyTableRawData_CL","dcr-00000000000000000000000000000000",new MonitorWorkspaceLogsSchemaMap(new MonitorWorkspaceLogsRecordMap[]
{
new MonitorWorkspaceLogsRecordMap("body","Body"),new MonitorWorkspaceLogsRecordMap("severity_text","SeverityText"),new MonitorWorkspaceLogsRecordMap("time_unix_nano","TimeGenerated")
})))
{
Concurrency = new MonitorWorkspaceLogsExporterConcurrencyConfiguration()
{
WorkerCount = 4,
BatchQueueSize = 100,
},
},
}
},
                Service = new PipelineGroupService(new PipelineGroupServicePipeline[]
            {
new PipelineGroupServicePipeline("MyPipelineForLogs1",PipelineGroupServicePipelineType.Logs,new string[]
{
"udp-receiver1"
},new string[]
{
"my-workspace-logs-exporter1"
})
{
Processors =
{
},
}
            }),
                Tags =
{
["tag1"] = "A",
["tag2"] = "B",
},
            };
            ArmOperation<PipelineGroupResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, pipelineGroupName, data);
            PipelineGroupResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            PipelineGroupData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create a PipelineGroup instance using a syslog receiver
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateAPipelineGroupInstanceUsingASyslogReceiver()
        {
            // Generated from example definition: specification/monitor/resource-manager/Microsoft.Monitor/preview/2023-10-01-preview/examples/PipelineGroupCreateSyslogs.json
            // this example is just showing the usage of "PipelineGroups_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this PipelineGroupResource
            PipelineGroupCollection collection = resourceGroupResource.GetPipelineGroups();

            // invoke the operation
            string pipelineGroupName = "plGroup1";
            PipelineGroupData data = new PipelineGroupData(new AzureLocation("eastus2"))
            {
                ExtendedLocation = new ExtendedLocation()
                {
                    Name = "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/microsoft.extendedlocation/customlocations/myTestCustomLocation",
                },
                Receivers =
{
new PipelineGroupReceiver(PipelineGroupReceiverType.Syslog,"syslog-receiver1")
{
Syslog = new SyslogReceiver("0.0.0.0:514"),
}
},
                Processors =
{
new PipelineGroupProcessor(PipelineGroupProcessorType.Batch,"batch-processor1")
},
                Exporters =
{
new PipelineGroupExporter(PipelineGroupExporterType.AzureMonitorWorkspaceLogs,"my-workspace-logs-exporter1")
{
AzureMonitorWorkspaceLogs = new MonitorWorkspaceLogsExporter(new MonitorWorkspaceLogsApiConfig(new Uri("https://logs-myingestion-eb0s.eastus-1.ingest.monitor.azure.com"),"Custom-MyTableRawData_CL","dcr-00000000000000000000000000000000",new MonitorWorkspaceLogsSchemaMap(new MonitorWorkspaceLogsRecordMap[]
{
new MonitorWorkspaceLogsRecordMap("body","Body"),new MonitorWorkspaceLogsRecordMap("severity_text","SeverityText"),new MonitorWorkspaceLogsRecordMap("time_unix_nano","TimeGenerated")
})))
{
Concurrency = new MonitorWorkspaceLogsExporterConcurrencyConfiguration()
{
WorkerCount = 4,
BatchQueueSize = 100,
},
},
}
},
                Service = new PipelineGroupService(new PipelineGroupServicePipeline[]
            {
new PipelineGroupServicePipeline("MyPipelineForLogs1",PipelineGroupServicePipelineType.Logs,new string[]
{
"syslog-receiver1"
},new string[]
{
"my-workspace-logs-exporter1"
})
{
Processors =
{
"batch-processor1"
},
}
            }),
                Tags =
{
["tag1"] = "A",
["tag2"] = "B",
},
            };
            ArmOperation<PipelineGroupResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, pipelineGroupName, data);
            PipelineGroupResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            PipelineGroupData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create a PipelineGroup instance using a syslog receiver and cache.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateAPipelineGroupInstanceUsingASyslogReceiverAndCache()
        {
            // Generated from example definition: specification/monitor/resource-manager/Microsoft.Monitor/preview/2023-10-01-preview/examples/PipelineGroupCreateSyslogsWithCache.json
            // this example is just showing the usage of "PipelineGroups_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this PipelineGroupResource
            PipelineGroupCollection collection = resourceGroupResource.GetPipelineGroups();

            // invoke the operation
            string pipelineGroupName = "plGroup1";
            PipelineGroupData data = new PipelineGroupData(new AzureLocation("eastus2"))
            {
                ExtendedLocation = new ExtendedLocation()
                {
                    Name = "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/microsoft.extendedlocation/customlocations/myTestCustomLocation",
                },
                Receivers =
{
new PipelineGroupReceiver(PipelineGroupReceiverType.Syslog,"syslog-receiver1")
{
Syslog = new SyslogReceiver("0.0.0.0:514"),
}
},
                Processors =
{
new PipelineGroupProcessor(PipelineGroupProcessorType.Batch,"batch-processor1")
},
                Exporters =
{
new PipelineGroupExporter(PipelineGroupExporterType.AzureMonitorWorkspaceLogs,"my-workspace-logs-exporter1")
{
AzureMonitorWorkspaceLogs = new MonitorWorkspaceLogsExporter(new MonitorWorkspaceLogsApiConfig(new Uri("https://logs-myingestion-eb0s.eastus-1.ingest.monitor.azure.com"),"Custom-MyTableRawData_CL","dcr-00000000000000000000000000000000",new MonitorWorkspaceLogsSchemaMap(new MonitorWorkspaceLogsRecordMap[]
{
new MonitorWorkspaceLogsRecordMap("body","Body"),new MonitorWorkspaceLogsRecordMap("severity_text","SeverityText"),new MonitorWorkspaceLogsRecordMap("time_unix_nano","TimeGenerated")
})))
{
Concurrency = new MonitorWorkspaceLogsExporterConcurrencyConfiguration()
{
WorkerCount = 4,
BatchQueueSize = 100,
},
Cache = new MonitorWorkspaceLogsExporterCacheConfiguration()
{
MaxStorageUsage = 100,
RetentionPeriod = 10,
},
},
}
},
                Service = new PipelineGroupService(new PipelineGroupServicePipeline[]
            {
new PipelineGroupServicePipeline("MyPipelineForLogs1",PipelineGroupServicePipelineType.Logs,new string[]
{
"syslog-receiver1"
},new string[]
{
"my-workspace-logs-exporter1"
})
{
Processors =
{
"batch-processor1"
},
}
            }),
                Tags =
{
["tag1"] = "A",
["tag2"] = "B",
},
            };
            ArmOperation<PipelineGroupResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, pipelineGroupName, data);
            PipelineGroupResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            PipelineGroupData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create a PipelineGroup instance using a syslog receiver and networking configurations.
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task CreateOrUpdate_CreateAPipelineGroupInstanceUsingASyslogReceiverAndNetworkingConfigurations()
        {
            // Generated from example definition: specification/monitor/resource-manager/Microsoft.Monitor/preview/2023-10-01-preview/examples/PipelineGroupCreateSyslogsWithNetworking.json
            // this example is just showing the usage of "PipelineGroups_CreateOrUpdate" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this ResourceGroupResource created on azure
            // for more information of creating ResourceGroupResource, please refer to the document of ResourceGroupResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "myResourceGroup";
            ResourceIdentifier resourceGroupResourceId = ResourceGroupResource.CreateResourceIdentifier(subscriptionId, resourceGroupName);
            ResourceGroupResource resourceGroupResource = client.GetResourceGroupResource(resourceGroupResourceId);

            // get the collection of this PipelineGroupResource
            PipelineGroupCollection collection = resourceGroupResource.GetPipelineGroups();

            // invoke the operation
            string pipelineGroupName = "plGroup1";
            PipelineGroupData data = new PipelineGroupData(new AzureLocation("eastus2"))
            {
                ExtendedLocation = new ExtendedLocation()
                {
                    Name = "/subscriptions/00000000-0000-0000-0000-000000000000/resourcegroups/myResourceGroup/providers/microsoft.extendedlocation/customlocations/myTestCustomLocation",
                },
                Receivers =
{
new PipelineGroupReceiver(PipelineGroupReceiverType.Syslog,"syslog-receiver1")
{
Syslog = new SyslogReceiver("0.0.0.0:514"),
}
},
                Processors =
{
},
                Exporters =
{
new PipelineGroupExporter(PipelineGroupExporterType.AzureMonitorWorkspaceLogs,"my-workspace-logs-exporter1")
{
AzureMonitorWorkspaceLogs = new MonitorWorkspaceLogsExporter(new MonitorWorkspaceLogsApiConfig(new Uri("https://logs-myingestion-eb0s.eastus-1.ingest.monitor.azure.com"),"Custom-MyTableRawData_CL","dcr-00000000000000000000000000000000",new MonitorWorkspaceLogsSchemaMap(new MonitorWorkspaceLogsRecordMap[]
{
new MonitorWorkspaceLogsRecordMap("body","Body"),new MonitorWorkspaceLogsRecordMap("severity_text","SeverityText"),new MonitorWorkspaceLogsRecordMap("time_unix_nano","TimeGenerated")
})))
{
Concurrency = new MonitorWorkspaceLogsExporterConcurrencyConfiguration()
{
WorkerCount = 4,
BatchQueueSize = 100,
},
},
}
},
                Service = new PipelineGroupService(new PipelineGroupServicePipeline[]
            {
new PipelineGroupServicePipeline("MyPipelineForLogs1",PipelineGroupServicePipelineType.Logs,new string[]
{
"syslog-receiver1"
},new string[]
{
"my-workspace-logs-exporter1"
})
{
Processors =
{
},
}
            }),
                NetworkingConfigurations =
{
new PipelineGroupNetworkingConfiguration(PipelineGroupExternalNetworkingMode.LoadBalancerOnly,new PipelineGroupNetworkingRoute[]
{
new PipelineGroupNetworkingRoute("syslog-receiver1")
})
{
Host = "azuremonitorpipeline.contoso.com",
}
},
                Tags =
{
["tag1"] = "A",
["tag2"] = "B",
},
            };
            ArmOperation<PipelineGroupResource> lro = await collection.CreateOrUpdateAsync(WaitUntil.Completed, pipelineGroupName, data);
            PipelineGroupResource result = lro.Value;

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            PipelineGroupData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
