// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Monitor.Models;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.Monitor.Samples
{
    public partial class Sample_MonitorWorkspaceResource
    {
        // List Azure Monitor Workspaces by subscription
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetMonitorWorkspaceResources_ListAzureMonitorWorkspacesBySubscription()
        {
            // Generated from example definition: specification/monitor/resource-manager/Microsoft.Monitor/preview/2023-10-01-preview/examples/AzureMonitorWorkspacesListBySubscription.json
            // this example is just showing the usage of "AzureMonitorWorkspaces_ListBySubscription" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionResource created on azure
            // for more information of creating SubscriptionResource, please refer to the document of SubscriptionResource
            string subscriptionId = "703362b3-f278-4e4b-9179-c76eaf41ffc2";
            ResourceIdentifier subscriptionResourceId = SubscriptionResource.CreateResourceIdentifier(subscriptionId);
            SubscriptionResource subscriptionResource = client.GetSubscriptionResource(subscriptionResourceId);

            // invoke the operation and iterate over the result
            await foreach (MonitorWorkspaceResource item in subscriptionResource.GetMonitorWorkspaceResourcesAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                MonitorWorkspaceResourceData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // Retrieves an Azure Monitor Workspace
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_RetrievesAnAzureMonitorWorkspace()
        {
            // Generated from example definition: specification/monitor/resource-manager/Microsoft.Monitor/preview/2023-10-01-preview/examples/AzureMonitorWorkspaceGet.json
            // this example is just showing the usage of "AzureMonitorWorkspaces_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MonitorWorkspaceResource created on azure
            // for more information of creating MonitorWorkspaceResource, please refer to the document of MonitorWorkspaceResource
            string subscriptionId = "703362b3-f278-4e4b-9179-c76eaf41ffc2";
            string resourceGroupName = "myResourceGroup";
            string azureMonitorWorkspaceName = "myAzureMonitorWorkspace";
            ResourceIdentifier monitorWorkspaceResourceId = MonitorWorkspaceResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, azureMonitorWorkspaceName);
            MonitorWorkspaceResource monitorWorkspaceResource = client.GetMonitorWorkspaceResource(monitorWorkspaceResourceId);

            // invoke the operation
            MonitorWorkspaceResource result = await monitorWorkspaceResource.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            MonitorWorkspaceResourceData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Updates an Azure Monitor Workspace
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdatesAnAzureMonitorWorkspace()
        {
            // Generated from example definition: specification/monitor/resource-manager/Microsoft.Monitor/preview/2023-10-01-preview/examples/AzureMonitorWorkspaceUpdate.json
            // this example is just showing the usage of "AzureMonitorWorkspaces_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MonitorWorkspaceResource created on azure
            // for more information of creating MonitorWorkspaceResource, please refer to the document of MonitorWorkspaceResource
            string subscriptionId = "703362b3-f278-4e4b-9179-c76eaf41ffc2";
            string resourceGroupName = "myResourceGroup";
            string azureMonitorWorkspaceName = "myAzureMonitorWorkspace";
            ResourceIdentifier monitorWorkspaceResourceId = MonitorWorkspaceResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, azureMonitorWorkspaceName);
            MonitorWorkspaceResource monitorWorkspaceResource = client.GetMonitorWorkspaceResource(monitorWorkspaceResourceId);

            // invoke the operation
            MonitorWorkspaceResourcePatch patch = new MonitorWorkspaceResourcePatch()
            {
                Tags =
{
["tag1"] = "A",
["tag2"] = "B",
["tag3"] = "C",
},
            };
            MonitorWorkspaceResource result = await monitorWorkspaceResource.UpdateAsync(patch);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            MonitorWorkspaceResourceData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Deletes an Azure Monitor Workspace asynchronously
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeletesAnAzureMonitorWorkspaceAsynchronously()
        {
            // Generated from example definition: specification/monitor/resource-manager/Microsoft.Monitor/preview/2023-10-01-preview/examples/AzureMonitorWorkspaceDelete.json
            // this example is just showing the usage of "AzureMonitorWorkspaces_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MonitorWorkspaceResource created on azure
            // for more information of creating MonitorWorkspaceResource, please refer to the document of MonitorWorkspaceResource
            string subscriptionId = "703362b3-f278-4e4b-9179-c76eaf41ffc2";
            string resourceGroupName = "myResourceGroup";
            string azureMonitorWorkspaceName = "myAzureMonitorWorkspace";
            ResourceIdentifier monitorWorkspaceResourceId = MonitorWorkspaceResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, azureMonitorWorkspaceName);
            MonitorWorkspaceResource monitorWorkspaceResource = client.GetMonitorWorkspaceResource(monitorWorkspaceResourceId);

            // invoke the operation
            await monitorWorkspaceResource.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
