// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using System.Xml;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Monitor.Models;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.Monitor.Samples
{
    public partial class Sample_MetricAlertResource
    {
        // List metric alert rules
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetMetricAlerts_ListMetricAlertRules()
        {
            // Generated from example definition: specification/monitor/resource-manager/Microsoft.Insights/stable/2018-03-01/examples/listMetricAlert.json
            // this example is just showing the usage of "MetricAlerts_ListBySubscription" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionResource created on azure
            // for more information of creating SubscriptionResource, please refer to the document of SubscriptionResource
            string subscriptionId = "14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7";
            ResourceIdentifier subscriptionResourceId = SubscriptionResource.CreateResourceIdentifier(subscriptionId);
            SubscriptionResource subscriptionResource = client.GetSubscriptionResource(subscriptionResourceId);

            // invoke the operation and iterate over the result
            await foreach (MetricAlertResource item in subscriptionResource.GetMetricAlertsAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                MetricAlertData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // Get a dynamic alert rule for multiple resources
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetADynamicAlertRuleForMultipleResources()
        {
            // Generated from example definition: specification/monitor/resource-manager/Microsoft.Insights/stable/2018-03-01/examples/getDynamicMetricAlertMultipleResource.json
            // this example is just showing the usage of "MetricAlerts_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MetricAlertResource created on azure
            // for more information of creating MetricAlertResource, please refer to the document of MetricAlertResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "gigtest";
            string ruleName = "MetricAlertOnMultipleResources";
            ResourceIdentifier metricAlertResourceId = MetricAlertResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, ruleName);
            MetricAlertResource metricAlert = client.GetMetricAlertResource(metricAlertResourceId);

            // invoke the operation
            MetricAlertResource result = await metricAlert.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            MetricAlertData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get a dynamic alert rule for single resource
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetADynamicAlertRuleForSingleResource()
        {
            // Generated from example definition: specification/monitor/resource-manager/Microsoft.Insights/stable/2018-03-01/examples/getDynamicMetricAlertSingleResource.json
            // this example is just showing the usage of "MetricAlerts_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MetricAlertResource created on azure
            // for more information of creating MetricAlertResource, please refer to the document of MetricAlertResource
            string subscriptionId = "00000000-0000-0000-0000-000000000000";
            string resourceGroupName = "gigtest";
            string ruleName = "chiricutin";
            ResourceIdentifier metricAlertResourceId = MetricAlertResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, ruleName);
            MetricAlertResource metricAlert = client.GetMetricAlertResource(metricAlertResourceId);

            // invoke the operation
            MetricAlertResource result = await metricAlert.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            MetricAlertData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get a web test alert rule
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetAWebTestAlertRule()
        {
            // Generated from example definition: specification/monitor/resource-manager/Microsoft.Insights/stable/2018-03-01/examples/getWebTestMetricAlert.json
            // this example is just showing the usage of "MetricAlerts_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MetricAlertResource created on azure
            // for more information of creating MetricAlertResource, please refer to the document of MetricAlertResource
            string subscriptionId = "12345678-1234-1234-1234-123456789101";
            string resourceGroupName = "rg-example";
            string ruleName = "webtest-name-example";
            ResourceIdentifier metricAlertResourceId = MetricAlertResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, ruleName);
            MetricAlertResource metricAlert = client.GetMetricAlertResource(metricAlertResourceId);

            // invoke the operation
            MetricAlertResource result = await metricAlert.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            MetricAlertData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get an alert rule for multiple resources
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetAnAlertRuleForMultipleResources()
        {
            // Generated from example definition: specification/monitor/resource-manager/Microsoft.Insights/stable/2018-03-01/examples/getMetricAlertMultipleResource.json
            // this example is just showing the usage of "MetricAlerts_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MetricAlertResource created on azure
            // for more information of creating MetricAlertResource, please refer to the document of MetricAlertResource
            string subscriptionId = "14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7";
            string resourceGroupName = "gigtest";
            string ruleName = "MetricAlertOnMultipleResources";
            ResourceIdentifier metricAlertResourceId = MetricAlertResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, ruleName);
            MetricAlertResource metricAlert = client.GetMetricAlertResource(metricAlertResourceId);

            // invoke the operation
            MetricAlertResource result = await metricAlert.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            MetricAlertData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get an alert rule for single resource
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetAnAlertRuleForSingleResource()
        {
            // Generated from example definition: specification/monitor/resource-manager/Microsoft.Insights/stable/2018-03-01/examples/getMetricAlertSingleResource.json
            // this example is just showing the usage of "MetricAlerts_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MetricAlertResource created on azure
            // for more information of creating MetricAlertResource, please refer to the document of MetricAlertResource
            string subscriptionId = "14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7";
            string resourceGroupName = "gigtest";
            string ruleName = "chiricutin";
            ResourceIdentifier metricAlertResourceId = MetricAlertResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, ruleName);
            MetricAlertResource metricAlert = client.GetMetricAlertResource(metricAlertResourceId);

            // invoke the operation
            MetricAlertResource result = await metricAlert.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            MetricAlertData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get an alert rule on resource group(s)
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetAnAlertRuleOnResourceGroupS()
        {
            // Generated from example definition: specification/monitor/resource-manager/Microsoft.Insights/stable/2018-03-01/examples/getMetricAlertResourceGroup.json
            // this example is just showing the usage of "MetricAlerts_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MetricAlertResource created on azure
            // for more information of creating MetricAlertResource, please refer to the document of MetricAlertResource
            string subscriptionId = "14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7";
            string resourceGroupName = "gigtest1";
            string ruleName = "MetricAlertAtResourceGroupLevel";
            ResourceIdentifier metricAlertResourceId = MetricAlertResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, ruleName);
            MetricAlertResource metricAlert = client.GetMetricAlertResource(metricAlertResourceId);

            // invoke the operation
            MetricAlertResource result = await metricAlert.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            MetricAlertData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Get an alert rule on subscription
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetAnAlertRuleOnSubscription()
        {
            // Generated from example definition: specification/monitor/resource-manager/Microsoft.Insights/stable/2018-03-01/examples/getMetricAlertSubscription.json
            // this example is just showing the usage of "MetricAlerts_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MetricAlertResource created on azure
            // for more information of creating MetricAlertResource, please refer to the document of MetricAlertResource
            string subscriptionId = "14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7";
            string resourceGroupName = "gigtest";
            string ruleName = "MetricAlertAtSubscriptionLevel";
            ResourceIdentifier metricAlertResourceId = MetricAlertResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, ruleName);
            MetricAlertResource metricAlert = client.GetMetricAlertResource(metricAlertResourceId);

            // invoke the operation
            MetricAlertResource result = await metricAlert.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            MetricAlertData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Create or update an alert rule
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_CreateOrUpdateAnAlertRule()
        {
            // Generated from example definition: specification/monitor/resource-manager/Microsoft.Insights/stable/2018-03-01/examples/UpdateMetricAlert.json
            // this example is just showing the usage of "MetricAlerts_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MetricAlertResource created on azure
            // for more information of creating MetricAlertResource, please refer to the document of MetricAlertResource
            string subscriptionId = "14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7";
            string resourceGroupName = "gigtest";
            string ruleName = "chiricutin";
            ResourceIdentifier metricAlertResourceId = MetricAlertResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, ruleName);
            MetricAlertResource metricAlert = client.GetMetricAlertResource(metricAlertResourceId);

            // invoke the operation
            MetricAlertPatch patch = new MetricAlertPatch()
            {
                Tags =
{
},
                Description = "This is the description of the rule1",
                Severity = 3,
                IsEnabled = true,
                Scopes =
{
"/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourceGroups/gigtest/providers/Microsoft.Compute/virtualMachines/gigwadme"
},
                EvaluationFrequency = XmlConvert.ToTimeSpan("Pt1m"),
                WindowSize = XmlConvert.ToTimeSpan("Pt15m"),
                Criteria = new MetricAlertSingleResourceMultipleMetricCriteria()
                {
                    AllOf =
{
new MetricCriteria("High_CPU_80","\\Processor(_Total)\\% Processor Time",MetricCriteriaTimeAggregationType.Average,MetricCriteriaOperator.GreaterThan,80.5)
{
Dimensions =
{
},
}
},
                },
                IsAutoMitigateEnabled = true,
                Actions =
{
new MetricAlertAction()
{
ActionGroupId = new ResourceIdentifier("/subscriptions/14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7/resourcegroups/gigtest/providers/microsoft.insights/actiongroups/group2"),
WebHookProperties =
{
["key11"] = "value11",
["key12"] = "value12",
},
}
},
            };
            MetricAlertResource result = await metricAlert.UpdateAsync(patch);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            MetricAlertData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Delete an alert rule
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeleteAnAlertRule()
        {
            // Generated from example definition: specification/monitor/resource-manager/Microsoft.Insights/stable/2018-03-01/examples/deleteMetricAlert.json
            // this example is just showing the usage of "MetricAlerts_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MetricAlertResource created on azure
            // for more information of creating MetricAlertResource, please refer to the document of MetricAlertResource
            string subscriptionId = "14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7";
            string resourceGroupName = "gigtest";
            string ruleName = "chiricutin";
            ResourceIdentifier metricAlertResourceId = MetricAlertResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, ruleName);
            MetricAlertResource metricAlert = client.GetMetricAlertResource(metricAlertResourceId);

            // invoke the operation
            await metricAlert.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // Get an alert rule status
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAllMetricAlertsStatus_GetAnAlertRuleStatus()
        {
            // Generated from example definition: specification/monitor/resource-manager/Microsoft.Insights/stable/2018-03-01/examples/getMetricAlertStatus.json
            // this example is just showing the usage of "MetricAlertsStatus_List" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MetricAlertResource created on azure
            // for more information of creating MetricAlertResource, please refer to the document of MetricAlertResource
            string subscriptionId = "14ddf0c5-77c5-4b53-84f6-e1fa43ad68f7";
            string resourceGroupName = "gigtest";
            string ruleName = "chiricutin";
            ResourceIdentifier metricAlertResourceId = MetricAlertResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, ruleName);
            MetricAlertResource metricAlert = client.GetMetricAlertResource(metricAlertResourceId);

            // invoke the operation and iterate over the result
            await foreach (MetricAlertStatus item in metricAlert.GetAllMetricAlertsStatusAsync())
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }

        // Get an alert rule status
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetAllMetricAlertsStatusByName_GetAnAlertRuleStatus()
        {
            // Generated from example definition: specification/monitor/resource-manager/Microsoft.Insights/stable/2018-03-01/examples/getMetricAlertStatusByName.json
            // this example is just showing the usage of "MetricAlertsStatus_ListByName" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this MetricAlertResource created on azure
            // for more information of creating MetricAlertResource, please refer to the document of MetricAlertResource
            string subscriptionId = "009f6022-67ec-423e-9aa7-691182870588";
            string resourceGroupName = "EastUs";
            string ruleName = "custom1";
            ResourceIdentifier metricAlertResourceId = MetricAlertResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, ruleName);
            MetricAlertResource metricAlert = client.GetMetricAlertResource(metricAlertResourceId);

            // invoke the operation and iterate over the result
            string statusName = "cmVzb3VyY2VJZD0vc3Vic2NyaXB0aW9ucy8xNGRkZjBjNS03N2M1LTRiNTMtODRmNi1lMWZhNDNhZDY4ZjcvcmVzb3VyY2VHcm91cHMvZ2lndGVzdC9wcm92aWRlcnMvTWljcm9zb2Z0LkNvbXB1dGUvdmlydHVhbE1hY2hpbmVzL2dpZ3dhZG1l";
            await foreach (MetricAlertStatus item in metricAlert.GetAllMetricAlertsStatusByNameAsync(statusName))
            {
                Console.WriteLine($"Succeeded: {item}");
            }

            Console.WriteLine($"Succeeded");
        }
    }
}
