// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Monitor.Models;

namespace Azure.ResourceManager.Monitor.Samples
{
    public partial class Sample_LogProfileResource
    {
        // Delete log profile
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeleteLogProfile()
        {
            // Generated from example definition: specification/monitor/resource-manager/Microsoft.Insights/stable/2016-03-01/examples/deleteLogProfile.json
            // this example is just showing the usage of "LogProfiles_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this LogProfileResource created on azure
            // for more information of creating LogProfileResource, please refer to the document of LogProfileResource
            string subscriptionId = "b67f7fec-69fc-4974-9099-a26bd6ffeda3";
            string logProfileName = "Rac46PostSwapRG";
            ResourceIdentifier logProfileResourceId = LogProfileResource.CreateResourceIdentifier(subscriptionId, logProfileName);
            LogProfileResource logProfile = client.GetLogProfileResource(logProfileResourceId);

            // invoke the operation
            await logProfile.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // Get log profile
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetLogProfile()
        {
            // Generated from example definition: specification/monitor/resource-manager/Microsoft.Insights/stable/2016-03-01/examples/getLogProfile.json
            // this example is just showing the usage of "LogProfiles_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this LogProfileResource created on azure
            // for more information of creating LogProfileResource, please refer to the document of LogProfileResource
            string subscriptionId = "df602c9c-7aa0-407d-a6fb-eb20c8bd1192";
            string logProfileName = "default";
            ResourceIdentifier logProfileResourceId = LogProfileResource.CreateResourceIdentifier(subscriptionId, logProfileName);
            LogProfileResource logProfile = client.GetLogProfileResource(logProfileResourceId);

            // invoke the operation
            LogProfileResource result = await logProfile.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            LogProfileData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Patch a log profile
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_PatchALogProfile()
        {
            // Generated from example definition: specification/monitor/resource-manager/Microsoft.Insights/stable/2016-03-01/examples/patchLogProfile.json
            // this example is just showing the usage of "LogProfiles_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this LogProfileResource created on azure
            // for more information of creating LogProfileResource, please refer to the document of LogProfileResource
            string subscriptionId = "df602c9c-7aa0-407d-a6fb-eb20c8bd1192";
            string logProfileName = "Rac46PostSwapRG";
            ResourceIdentifier logProfileResourceId = LogProfileResource.CreateResourceIdentifier(subscriptionId, logProfileName);
            LogProfileResource logProfile = client.GetLogProfileResource(logProfileResourceId);

            // invoke the operation
            LogProfilePatch patch = new LogProfilePatch()
            {
                Tags =
{
["key1"] = "value1",
},
                StorageAccountId = new ResourceIdentifier("/subscriptions/df602c9c-7aa0-407d-a6fb-eb20c8bd1192/resourceGroups/JohnKemTest/providers/Microsoft.Storage/storageAccounts/johnkemtest8162"),
                ServiceBusRuleId = new ResourceIdentifier(""),
                Locations =
{
new AzureLocation("global")
},
                Categories =
{
"Write","Delete","Action"
},
                RetentionPolicy = new RetentionPolicy(true, 3),
            };
            LogProfileResource result = await logProfile.UpdateAsync(patch);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            LogProfileData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
