// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;

namespace Azure.ResourceManager.Monitor.Samples
{
    public partial class Sample_DiagnosticSettingsCategoryResource
    {
        // Gets the diagnostic setting
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetsTheDiagnosticSetting()
        {
            // Generated from example definition: specification/monitor/resource-manager/Microsoft.Insights/preview/2021-05-01-preview/examples/getDiagnosticSettingsCategory.json
            // this example is just showing the usage of "DiagnosticSettingsCategory_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DiagnosticSettingsCategoryResource created on azure
            // for more information of creating DiagnosticSettingsCategoryResource, please refer to the document of DiagnosticSettingsCategoryResource
            string resourceUri = "subscriptions/1a66ce04-b633-4a0b-b2bc-a912ec8986a6/resourcegroups/viruela1/providers/microsoft.logic/workflows/viruela6";
            string name = "WorkflowRuntime";
            ResourceIdentifier diagnosticSettingsCategoryResourceId = DiagnosticSettingsCategoryResource.CreateResourceIdentifier(resourceUri, name);
            DiagnosticSettingsCategoryResource diagnosticSettingsCategory = client.GetDiagnosticSettingsCategoryResource(diagnosticSettingsCategoryResourceId);

            // invoke the operation
            DiagnosticSettingsCategoryResource result = await diagnosticSettingsCategory.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            DiagnosticSettingsCategoryData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }
    }
}
