// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Monitor.Models;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.Monitor.Samples
{
    public partial class Sample_DataCollectionRuleResource
    {
        // List associations for specified data collection rule
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetDataCollectionRuleAssociationsByRule_ListAssociationsForSpecifiedDataCollectionRule()
        {
            // Generated from example definition: specification/monitor/resource-manager/Microsoft.Insights/stable/2022-06-01/examples/DataCollectionRuleAssociationsListByRule.json
            // this example is just showing the usage of "DataCollectionRuleAssociations_ListByRule" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DataCollectionRuleResource created on azure
            // for more information of creating DataCollectionRuleResource, please refer to the document of DataCollectionRuleResource
            string subscriptionId = "703362b3-f278-4e4b-9179-c76eaf41ffc2";
            string resourceGroupName = "myResourceGroup";
            string dataCollectionRuleName = "myCollectionRule";
            ResourceIdentifier dataCollectionRuleResourceId = DataCollectionRuleResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, dataCollectionRuleName);
            DataCollectionRuleResource dataCollectionRule = client.GetDataCollectionRuleResource(dataCollectionRuleResourceId);

            // invoke the operation and iterate over the result
            await foreach (DataCollectionRuleAssociationResource item in dataCollectionRule.GetDataCollectionRuleAssociationsByRuleAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                DataCollectionRuleAssociationData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // List data collection rules by subscription
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetDataCollectionRules_ListDataCollectionRulesBySubscription()
        {
            // Generated from example definition: specification/monitor/resource-manager/Microsoft.Insights/stable/2022-06-01/examples/DataCollectionRulesListBySubscription.json
            // this example is just showing the usage of "DataCollectionRules_ListBySubscription" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionResource created on azure
            // for more information of creating SubscriptionResource, please refer to the document of SubscriptionResource
            string subscriptionId = "703362b3-f278-4e4b-9179-c76eaf41ffc2";
            ResourceIdentifier subscriptionResourceId = SubscriptionResource.CreateResourceIdentifier(subscriptionId);
            SubscriptionResource subscriptionResource = client.GetSubscriptionResource(subscriptionResourceId);

            // invoke the operation and iterate over the result
            await foreach (DataCollectionRuleResource item in subscriptionResource.GetDataCollectionRulesAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                DataCollectionRuleData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // Get data collection rule
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetDataCollectionRule()
        {
            // Generated from example definition: specification/monitor/resource-manager/Microsoft.Insights/stable/2022-06-01/examples/DataCollectionRulesGet.json
            // this example is just showing the usage of "DataCollectionRules_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DataCollectionRuleResource created on azure
            // for more information of creating DataCollectionRuleResource, please refer to the document of DataCollectionRuleResource
            string subscriptionId = "703362b3-f278-4e4b-9179-c76eaf41ffc2";
            string resourceGroupName = "myResourceGroup";
            string dataCollectionRuleName = "myCollectionRule";
            ResourceIdentifier dataCollectionRuleResourceId = DataCollectionRuleResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, dataCollectionRuleName);
            DataCollectionRuleResource dataCollectionRule = client.GetDataCollectionRuleResource(dataCollectionRuleResourceId);

            // invoke the operation
            DataCollectionRuleResource result = await dataCollectionRule.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            DataCollectionRuleData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Update data collection rule
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdateDataCollectionRule()
        {
            // Generated from example definition: specification/monitor/resource-manager/Microsoft.Insights/stable/2022-06-01/examples/DataCollectionRulesUpdate.json
            // this example is just showing the usage of "DataCollectionRules_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DataCollectionRuleResource created on azure
            // for more information of creating DataCollectionRuleResource, please refer to the document of DataCollectionRuleResource
            string subscriptionId = "703362b3-f278-4e4b-9179-c76eaf41ffc2";
            string resourceGroupName = "myResourceGroup";
            string dataCollectionRuleName = "myCollectionRule";
            ResourceIdentifier dataCollectionRuleResourceId = DataCollectionRuleResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, dataCollectionRuleName);
            DataCollectionRuleResource dataCollectionRule = client.GetDataCollectionRuleResource(dataCollectionRuleResourceId);

            // invoke the operation
            ResourceForUpdate body = new ResourceForUpdate()
            {
                Tags =
{
["tag1"] = "A",
["tag2"] = "B",
["tag3"] = "C",
},
            };
            DataCollectionRuleResource result = await dataCollectionRule.UpdateAsync(body);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            DataCollectionRuleData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Delete data collection rule
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeleteDataCollectionRule()
        {
            // Generated from example definition: specification/monitor/resource-manager/Microsoft.Insights/stable/2022-06-01/examples/DataCollectionRulesDelete.json
            // this example is just showing the usage of "DataCollectionRules_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DataCollectionRuleResource created on azure
            // for more information of creating DataCollectionRuleResource, please refer to the document of DataCollectionRuleResource
            string subscriptionId = "703362b3-f278-4e4b-9179-c76eaf41ffc2";
            string resourceGroupName = "myResourceGroup";
            string dataCollectionRuleName = "myCollectionRule";
            ResourceIdentifier dataCollectionRuleResourceId = DataCollectionRuleResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, dataCollectionRuleName);
            DataCollectionRuleResource dataCollectionRule = client.GetDataCollectionRuleResource(dataCollectionRuleResourceId);

            // invoke the operation
            await dataCollectionRule.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }
    }
}
