// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Monitor.Models;
using Azure.ResourceManager.Resources;

namespace Azure.ResourceManager.Monitor.Samples
{
    public partial class Sample_DataCollectionEndpointResource
    {
        // List data collection endpoints by subscription
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetDataCollectionEndpoints_ListDataCollectionEndpointsBySubscription()
        {
            // Generated from example definition: specification/monitor/resource-manager/Microsoft.Insights/stable/2022-06-01/examples/DataCollectionEndpointsListBySubscription.json
            // this example is just showing the usage of "DataCollectionEndpoints_ListBySubscription" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this SubscriptionResource created on azure
            // for more information of creating SubscriptionResource, please refer to the document of SubscriptionResource
            string subscriptionId = "703362b3-f278-4e4b-9179-c76eaf41ffc2";
            ResourceIdentifier subscriptionResourceId = SubscriptionResource.CreateResourceIdentifier(subscriptionId);
            SubscriptionResource subscriptionResource = client.GetSubscriptionResource(subscriptionResourceId);

            // invoke the operation and iterate over the result
            await foreach (DataCollectionEndpointResource item in subscriptionResource.GetDataCollectionEndpointsAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                DataCollectionEndpointData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }

        // Get data collection endpoint
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Get_GetDataCollectionEndpoint()
        {
            // Generated from example definition: specification/monitor/resource-manager/Microsoft.Insights/stable/2022-06-01/examples/DataCollectionEndpointsGet.json
            // this example is just showing the usage of "DataCollectionEndpoints_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DataCollectionEndpointResource created on azure
            // for more information of creating DataCollectionEndpointResource, please refer to the document of DataCollectionEndpointResource
            string subscriptionId = "703362b3-f278-4e4b-9179-c76eaf41ffc2";
            string resourceGroupName = "myResourceGroup";
            string dataCollectionEndpointName = "myCollectionEndpoint";
            ResourceIdentifier dataCollectionEndpointResourceId = DataCollectionEndpointResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, dataCollectionEndpointName);
            DataCollectionEndpointResource dataCollectionEndpoint = client.GetDataCollectionEndpointResource(dataCollectionEndpointResourceId);

            // invoke the operation
            DataCollectionEndpointResource result = await dataCollectionEndpoint.GetAsync();

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            DataCollectionEndpointData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Update data collection endpoint
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Update_UpdateDataCollectionEndpoint()
        {
            // Generated from example definition: specification/monitor/resource-manager/Microsoft.Insights/stable/2022-06-01/examples/DataCollectionEndpointsUpdate.json
            // this example is just showing the usage of "DataCollectionEndpoints_Update" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DataCollectionEndpointResource created on azure
            // for more information of creating DataCollectionEndpointResource, please refer to the document of DataCollectionEndpointResource
            string subscriptionId = "703362b3-f278-4e4b-9179-c76eaf41ffc2";
            string resourceGroupName = "myResourceGroup";
            string dataCollectionEndpointName = "myCollectionEndpoint";
            ResourceIdentifier dataCollectionEndpointResourceId = DataCollectionEndpointResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, dataCollectionEndpointName);
            DataCollectionEndpointResource dataCollectionEndpoint = client.GetDataCollectionEndpointResource(dataCollectionEndpointResourceId);

            // invoke the operation
            ResourceForUpdate body = new ResourceForUpdate()
            {
                Tags =
{
["tag1"] = "A",
["tag2"] = "B",
["tag3"] = "C",
},
            };
            DataCollectionEndpointResource result = await dataCollectionEndpoint.UpdateAsync(body);

            // the variable result is a resource, you could call other operations on this instance as well
            // but just for demo, we get its data from this resource instance
            DataCollectionEndpointData resourceData = result.Data;
            // for demo we just print out the id
            Console.WriteLine($"Succeeded on id: {resourceData.Id}");
        }

        // Delete data collection endpoint
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task Delete_DeleteDataCollectionEndpoint()
        {
            // Generated from example definition: specification/monitor/resource-manager/Microsoft.Insights/stable/2022-06-01/examples/DataCollectionEndpointsDelete.json
            // this example is just showing the usage of "DataCollectionEndpoints_Delete" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DataCollectionEndpointResource created on azure
            // for more information of creating DataCollectionEndpointResource, please refer to the document of DataCollectionEndpointResource
            string subscriptionId = "703362b3-f278-4e4b-9179-c76eaf41ffc2";
            string resourceGroupName = "myResourceGroup";
            string dataCollectionEndpointName = "myCollectionEndpoint";
            ResourceIdentifier dataCollectionEndpointResourceId = DataCollectionEndpointResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, dataCollectionEndpointName);
            DataCollectionEndpointResource dataCollectionEndpoint = client.GetDataCollectionEndpointResource(dataCollectionEndpointResourceId);

            // invoke the operation
            await dataCollectionEndpoint.DeleteAsync(WaitUntil.Completed);

            Console.WriteLine($"Succeeded");
        }

        // List associations for specified data collection endpoint
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetDataCollectionRuleAssociations_ListAssociationsForSpecifiedDataCollectionEndpoint()
        {
            // Generated from example definition: specification/monitor/resource-manager/Microsoft.Insights/stable/2022-06-01/examples/DataCollectionRuleAssociationsListByDataCollectionEndpoint.json
            // this example is just showing the usage of "DataCollectionRuleAssociations_ListByDataCollectionEndpoint" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this DataCollectionEndpointResource created on azure
            // for more information of creating DataCollectionEndpointResource, please refer to the document of DataCollectionEndpointResource
            string subscriptionId = "703362b3-f278-4e4b-9179-c76eaf41ffc2";
            string resourceGroupName = "myResourceGroup";
            string dataCollectionEndpointName = "myDataCollectionEndpointName";
            ResourceIdentifier dataCollectionEndpointResourceId = DataCollectionEndpointResource.CreateResourceIdentifier(subscriptionId, resourceGroupName, dataCollectionEndpointName);
            DataCollectionEndpointResource dataCollectionEndpoint = client.GetDataCollectionEndpointResource(dataCollectionEndpointResourceId);

            // invoke the operation and iterate over the result
            await foreach (DataCollectionRuleAssociationResource item in dataCollectionEndpoint.GetDataCollectionRuleAssociationsAsync())
            {
                // the variable item is a resource, you could call other operations on this instance as well
                // but just for demo, we get its data from this resource instance
                DataCollectionRuleAssociationData resourceData = item.Data;
                // for demo we just print out the id
                Console.WriteLine($"Succeeded on id: {resourceData.Id}");
            }

            Console.WriteLine($"Succeeded");
        }
    }
}
