// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Threading.Tasks;
using System.Xml;
using Azure;
using Azure.Core;
using Azure.Identity;
using Azure.Monitor.Query;
using NUnit.Framework;

namespace Azure.Monitor.Query.Samples
{
    public partial class Samples_MetricsClient
    {
        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetAtSubscriptionScopes_ShortVersion()
        {
            MetricsClient client = new MetricsClient("<SubscriptionId>");

            Response response = client.GetAtSubscriptionScopes("<region>", null, null, null, null, null, null, null, null, null, null, null, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("timespan").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("name").GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("unit").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("timeseries")[0].ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetAtSubscriptionScopes_ShortVersion_Async()
        {
            MetricsClient client = new MetricsClient("<SubscriptionId>");

            Response response = await client.GetAtSubscriptionScopesAsync("<region>", null, null, null, null, null, null, null, null, null, null, null, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("timespan").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("name").GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("unit").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("timeseries")[0].ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetAtSubscriptionScopes_AllParameters()
        {
            MetricsClient client = new MetricsClient("<SubscriptionId>");

            Response response = client.GetAtSubscriptionScopes("<region>", "<timespan>", XmlConvert.ToTimeSpan("PT1H23M45S"), "<metricnames>", "<aggregation>", 1234, "<orderby>", "<filter>", "Data", "<metricnamespace>", true, true, "<rollupby>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("cost").ToString());
            Console.WriteLine(result.GetProperty("timespan").ToString());
            Console.WriteLine(result.GetProperty("interval").ToString());
            Console.WriteLine(result.GetProperty("namespace").ToString());
            Console.WriteLine(result.GetProperty("resourceregion").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("name").GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("name").GetProperty("localizedValue").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("displayDescription").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("errorCode").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("errorMessage").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("unit").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("timeseries")[0].GetProperty("metadatavalues")[0].GetProperty("name").GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("timeseries")[0].GetProperty("metadatavalues")[0].GetProperty("name").GetProperty("localizedValue").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("timeseries")[0].GetProperty("metadatavalues")[0].GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("timeseries")[0].GetProperty("data")[0].GetProperty("timeStamp").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("timeseries")[0].GetProperty("data")[0].GetProperty("average").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("timeseries")[0].GetProperty("data")[0].GetProperty("minimum").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("timeseries")[0].GetProperty("data")[0].GetProperty("maximum").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("timeseries")[0].GetProperty("data")[0].GetProperty("total").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("timeseries")[0].GetProperty("data")[0].GetProperty("count").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetAtSubscriptionScopes_AllParameters_Async()
        {
            MetricsClient client = new MetricsClient("<SubscriptionId>");

            Response response = await client.GetAtSubscriptionScopesAsync("<region>", "<timespan>", XmlConvert.ToTimeSpan("PT1H23M45S"), "<metricnames>", "<aggregation>", 1234, "<orderby>", "<filter>", "Data", "<metricnamespace>", true, true, "<rollupby>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("cost").ToString());
            Console.WriteLine(result.GetProperty("timespan").ToString());
            Console.WriteLine(result.GetProperty("interval").ToString());
            Console.WriteLine(result.GetProperty("namespace").ToString());
            Console.WriteLine(result.GetProperty("resourceregion").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("name").GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("name").GetProperty("localizedValue").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("displayDescription").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("errorCode").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("errorMessage").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("unit").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("timeseries")[0].GetProperty("metadatavalues")[0].GetProperty("name").GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("timeseries")[0].GetProperty("metadatavalues")[0].GetProperty("name").GetProperty("localizedValue").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("timeseries")[0].GetProperty("metadatavalues")[0].GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("timeseries")[0].GetProperty("data")[0].GetProperty("timeStamp").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("timeseries")[0].GetProperty("data")[0].GetProperty("average").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("timeseries")[0].GetProperty("data")[0].GetProperty("minimum").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("timeseries")[0].GetProperty("data")[0].GetProperty("maximum").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("timeseries")[0].GetProperty("data")[0].GetProperty("total").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("timeseries")[0].GetProperty("data")[0].GetProperty("count").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetAtSubscriptionScopePosts_ShortVersion()
        {
            MetricsClient client = new MetricsClient("<SubscriptionId>");

            using RequestContent content = null;
            Response response = client.GetAtSubscriptionScopePosts("<region>", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("timespan").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("name").GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("unit").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("timeseries")[0].ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetAtSubscriptionScopePosts_ShortVersion_Async()
        {
            MetricsClient client = new MetricsClient("<SubscriptionId>");

            using RequestContent content = null;
            Response response = await client.GetAtSubscriptionScopePostsAsync("<region>", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("timespan").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("name").GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("unit").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("timeseries")[0].ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetAtSubscriptionScopePosts_AllParameters()
        {
            MetricsClient client = new MetricsClient("<SubscriptionId>");

            using RequestContent content = RequestContent.Create(new
            {
                timespan = "<timespan>",
                interval = "<interval>",
                metricNames = "<metricNames>",
                aggregation = "<aggregation>",
                filter = "<filter>",
                top = 1234,
                orderBy = "<orderBy>",
                rollUpBy = "<rollUpBy>",
                resultType = "Data",
                metricNamespace = "<metricNamespace>",
                autoAdjustTimegrain = true,
                validateDimensions = true,
            });
            Response response = client.GetAtSubscriptionScopePosts("<region>", content, timespan: "<timespan>", interval: XmlConvert.ToTimeSpan("PT1H23M45S"), metricnames: "<metricnames>", aggregation: "<aggregation>", top: 1234, orderby: "<orderby>", filter: "<filter>", resultType: "Data", metricnamespace: "<metricnamespace>", autoAdjustTimegrain: true, validateDimensions: true, rollupby: "<rollupby>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("cost").ToString());
            Console.WriteLine(result.GetProperty("timespan").ToString());
            Console.WriteLine(result.GetProperty("interval").ToString());
            Console.WriteLine(result.GetProperty("namespace").ToString());
            Console.WriteLine(result.GetProperty("resourceregion").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("name").GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("name").GetProperty("localizedValue").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("displayDescription").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("errorCode").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("errorMessage").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("unit").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("timeseries")[0].GetProperty("metadatavalues")[0].GetProperty("name").GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("timeseries")[0].GetProperty("metadatavalues")[0].GetProperty("name").GetProperty("localizedValue").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("timeseries")[0].GetProperty("metadatavalues")[0].GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("timeseries")[0].GetProperty("data")[0].GetProperty("timeStamp").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("timeseries")[0].GetProperty("data")[0].GetProperty("average").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("timeseries")[0].GetProperty("data")[0].GetProperty("minimum").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("timeseries")[0].GetProperty("data")[0].GetProperty("maximum").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("timeseries")[0].GetProperty("data")[0].GetProperty("total").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("timeseries")[0].GetProperty("data")[0].GetProperty("count").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetAtSubscriptionScopePosts_AllParameters_Async()
        {
            MetricsClient client = new MetricsClient("<SubscriptionId>");

            using RequestContent content = RequestContent.Create(new
            {
                timespan = "<timespan>",
                interval = "<interval>",
                metricNames = "<metricNames>",
                aggregation = "<aggregation>",
                filter = "<filter>",
                top = 1234,
                orderBy = "<orderBy>",
                rollUpBy = "<rollUpBy>",
                resultType = "Data",
                metricNamespace = "<metricNamespace>",
                autoAdjustTimegrain = true,
                validateDimensions = true,
            });
            Response response = await client.GetAtSubscriptionScopePostsAsync("<region>", content, timespan: "<timespan>", interval: XmlConvert.ToTimeSpan("PT1H23M45S"), metricnames: "<metricnames>", aggregation: "<aggregation>", top: 1234, orderby: "<orderby>", filter: "<filter>", resultType: "Data", metricnamespace: "<metricnamespace>", autoAdjustTimegrain: true, validateDimensions: true, rollupby: "<rollupby>");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("cost").ToString());
            Console.WriteLine(result.GetProperty("timespan").ToString());
            Console.WriteLine(result.GetProperty("interval").ToString());
            Console.WriteLine(result.GetProperty("namespace").ToString());
            Console.WriteLine(result.GetProperty("resourceregion").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("name").GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("name").GetProperty("localizedValue").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("displayDescription").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("errorCode").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("errorMessage").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("unit").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("timeseries")[0].GetProperty("metadatavalues")[0].GetProperty("name").GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("timeseries")[0].GetProperty("metadatavalues")[0].GetProperty("name").GetProperty("localizedValue").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("timeseries")[0].GetProperty("metadatavalues")[0].GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("timeseries")[0].GetProperty("data")[0].GetProperty("timeStamp").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("timeseries")[0].GetProperty("data")[0].GetProperty("average").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("timeseries")[0].GetProperty("data")[0].GetProperty("minimum").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("timeseries")[0].GetProperty("data")[0].GetProperty("maximum").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("timeseries")[0].GetProperty("data")[0].GetProperty("total").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("timeseries")[0].GetProperty("data")[0].GetProperty("count").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetMetrics_ShortVersion()
        {
            MetricsClient client = new MetricsClient(null);

            Response response = client.GetMetrics("<resourceUri>", null, null, null, null, null, null, null, null, null, null, null, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("timespan").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("name").GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("unit").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("timeseries")[0].ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetMetrics_ShortVersion_Async()
        {
            MetricsClient client = new MetricsClient(null);

            Response response = await client.GetMetricsAsync("<resourceUri>", null, null, null, null, null, null, null, null, null, null, null, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("timespan").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("name").GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("unit").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("timeseries")[0].ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetMetrics_AllParameters()
        {
            MetricsClient client = new MetricsClient(null);

            Response response = client.GetMetrics("<resourceUri>", "<timespan>", XmlConvert.ToTimeSpan("PT1H23M45S"), "<metricnames>", "<aggregation>", 1234, "<orderby>", "<filter>", "Data", "<metricnamespace>", true, true, "<rollupby>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("cost").ToString());
            Console.WriteLine(result.GetProperty("timespan").ToString());
            Console.WriteLine(result.GetProperty("interval").ToString());
            Console.WriteLine(result.GetProperty("namespace").ToString());
            Console.WriteLine(result.GetProperty("resourceregion").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("name").GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("name").GetProperty("localizedValue").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("displayDescription").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("errorCode").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("errorMessage").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("unit").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("timeseries")[0].GetProperty("metadatavalues")[0].GetProperty("name").GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("timeseries")[0].GetProperty("metadatavalues")[0].GetProperty("name").GetProperty("localizedValue").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("timeseries")[0].GetProperty("metadatavalues")[0].GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("timeseries")[0].GetProperty("data")[0].GetProperty("timeStamp").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("timeseries")[0].GetProperty("data")[0].GetProperty("average").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("timeseries")[0].GetProperty("data")[0].GetProperty("minimum").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("timeseries")[0].GetProperty("data")[0].GetProperty("maximum").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("timeseries")[0].GetProperty("data")[0].GetProperty("total").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("timeseries")[0].GetProperty("data")[0].GetProperty("count").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetMetrics_AllParameters_Async()
        {
            MetricsClient client = new MetricsClient(null);

            Response response = await client.GetMetricsAsync("<resourceUri>", "<timespan>", XmlConvert.ToTimeSpan("PT1H23M45S"), "<metricnames>", "<aggregation>", 1234, "<orderby>", "<filter>", "Data", "<metricnamespace>", true, true, "<rollupby>", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("cost").ToString());
            Console.WriteLine(result.GetProperty("timespan").ToString());
            Console.WriteLine(result.GetProperty("interval").ToString());
            Console.WriteLine(result.GetProperty("namespace").ToString());
            Console.WriteLine(result.GetProperty("resourceregion").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("name").GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("name").GetProperty("localizedValue").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("displayDescription").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("errorCode").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("errorMessage").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("unit").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("timeseries")[0].GetProperty("metadatavalues")[0].GetProperty("name").GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("timeseries")[0].GetProperty("metadatavalues")[0].GetProperty("name").GetProperty("localizedValue").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("timeseries")[0].GetProperty("metadatavalues")[0].GetProperty("value").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("timeseries")[0].GetProperty("data")[0].GetProperty("timeStamp").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("timeseries")[0].GetProperty("data")[0].GetProperty("average").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("timeseries")[0].GetProperty("data")[0].GetProperty("minimum").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("timeseries")[0].GetProperty("data")[0].GetProperty("maximum").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("timeseries")[0].GetProperty("data")[0].GetProperty("total").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("timeseries")[0].GetProperty("data")[0].GetProperty("count").ToString());
        }
    }
}
