// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Threading.Tasks;
using Azure;
using Azure.Identity;
using Azure.Monitor.Query;
using NUnit.Framework;

namespace Azure.Monitor.Query.Samples
{
    public partial class Samples_MetricNamespacesClient
    {
        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetMetricNamespaces_ShortVersion()
        {
            MetricNamespacesClient client = new MetricNamespacesClient();

            foreach (BinaryData item in client.GetMetricNamespaces("<resourceUri>", null, null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetMetricNamespaces_ShortVersion_Async()
        {
            MetricNamespacesClient client = new MetricNamespacesClient();

            await foreach (BinaryData item in client.GetMetricNamespacesAsync("<resourceUri>", null, null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetMetricNamespaces_AllParameters()
        {
            MetricNamespacesClient client = new MetricNamespacesClient();

            foreach (BinaryData item in client.GetMetricNamespaces("<resourceUri>", "<startTime>", null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("id").ToString());
                Console.WriteLine(result.GetProperty("type").ToString());
                Console.WriteLine(result.GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("classification").ToString());
                Console.WriteLine(result.GetProperty("properties").GetProperty("metricNamespaceName").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetMetricNamespaces_AllParameters_Async()
        {
            MetricNamespacesClient client = new MetricNamespacesClient();

            await foreach (BinaryData item in client.GetMetricNamespacesAsync("<resourceUri>", "<startTime>", null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("id").ToString());
                Console.WriteLine(result.GetProperty("type").ToString());
                Console.WriteLine(result.GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("classification").ToString());
                Console.WriteLine(result.GetProperty("properties").GetProperty("metricNamespaceName").ToString());
            }
        }
    }
}
