// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Threading.Tasks;
using Azure;
using Azure.Identity;
using Azure.Monitor.Query;
using NUnit.Framework;

namespace Azure.Monitor.Query.Samples
{
    public partial class Samples_MetricDefinitionsClient
    {
        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetAtSubscriptionScopes_ShortVersion()
        {
            MetricDefinitionsClient client = new MetricDefinitionsClient("<SubscriptionId>");

            foreach (BinaryData item in client.GetAtSubscriptionScopes("<region>", null, null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetAtSubscriptionScopes_ShortVersion_Async()
        {
            MetricDefinitionsClient client = new MetricDefinitionsClient("<SubscriptionId>");

            await foreach (BinaryData item in client.GetAtSubscriptionScopesAsync("<region>", null, null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetAtSubscriptionScopes_AllParameters()
        {
            MetricDefinitionsClient client = new MetricDefinitionsClient("<SubscriptionId>");

            foreach (BinaryData item in client.GetAtSubscriptionScopes("<region>", "<metricnamespace>", null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("isDimensionRequired").ToString());
                Console.WriteLine(result.GetProperty("resourceId").ToString());
                Console.WriteLine(result.GetProperty("namespace").ToString());
                Console.WriteLine(result.GetProperty("name").GetProperty("value").ToString());
                Console.WriteLine(result.GetProperty("name").GetProperty("localizedValue").ToString());
                Console.WriteLine(result.GetProperty("displayDescription").ToString());
                Console.WriteLine(result.GetProperty("category").ToString());
                Console.WriteLine(result.GetProperty("metricClass").ToString());
                Console.WriteLine(result.GetProperty("unit").ToString());
                Console.WriteLine(result.GetProperty("primaryAggregationType").ToString());
                Console.WriteLine(result.GetProperty("supportedAggregationTypes")[0].ToString());
                Console.WriteLine(result.GetProperty("metricAvailabilities")[0].GetProperty("timeGrain").ToString());
                Console.WriteLine(result.GetProperty("metricAvailabilities")[0].GetProperty("retention").ToString());
                Console.WriteLine(result.GetProperty("id").ToString());
                Console.WriteLine(result.GetProperty("dimensions")[0].GetProperty("value").ToString());
                Console.WriteLine(result.GetProperty("dimensions")[0].GetProperty("localizedValue").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetAtSubscriptionScopes_AllParameters_Async()
        {
            MetricDefinitionsClient client = new MetricDefinitionsClient("<SubscriptionId>");

            await foreach (BinaryData item in client.GetAtSubscriptionScopesAsync("<region>", "<metricnamespace>", null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("isDimensionRequired").ToString());
                Console.WriteLine(result.GetProperty("resourceId").ToString());
                Console.WriteLine(result.GetProperty("namespace").ToString());
                Console.WriteLine(result.GetProperty("name").GetProperty("value").ToString());
                Console.WriteLine(result.GetProperty("name").GetProperty("localizedValue").ToString());
                Console.WriteLine(result.GetProperty("displayDescription").ToString());
                Console.WriteLine(result.GetProperty("category").ToString());
                Console.WriteLine(result.GetProperty("metricClass").ToString());
                Console.WriteLine(result.GetProperty("unit").ToString());
                Console.WriteLine(result.GetProperty("primaryAggregationType").ToString());
                Console.WriteLine(result.GetProperty("supportedAggregationTypes")[0].ToString());
                Console.WriteLine(result.GetProperty("metricAvailabilities")[0].GetProperty("timeGrain").ToString());
                Console.WriteLine(result.GetProperty("metricAvailabilities")[0].GetProperty("retention").ToString());
                Console.WriteLine(result.GetProperty("id").ToString());
                Console.WriteLine(result.GetProperty("dimensions")[0].GetProperty("value").ToString());
                Console.WriteLine(result.GetProperty("dimensions")[0].GetProperty("localizedValue").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetMetricDefinitions_ShortVersion()
        {
            MetricDefinitionsClient client = new MetricDefinitionsClient(null);

            foreach (BinaryData item in client.GetMetricDefinitions("<resourceUri>", null, null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetMetricDefinitions_ShortVersion_Async()
        {
            MetricDefinitionsClient client = new MetricDefinitionsClient(null);

            await foreach (BinaryData item in client.GetMetricDefinitionsAsync("<resourceUri>", null, null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetMetricDefinitions_AllParameters()
        {
            MetricDefinitionsClient client = new MetricDefinitionsClient(null);

            foreach (BinaryData item in client.GetMetricDefinitions("<resourceUri>", "<metricnamespace>", null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("isDimensionRequired").ToString());
                Console.WriteLine(result.GetProperty("resourceId").ToString());
                Console.WriteLine(result.GetProperty("namespace").ToString());
                Console.WriteLine(result.GetProperty("name").GetProperty("value").ToString());
                Console.WriteLine(result.GetProperty("name").GetProperty("localizedValue").ToString());
                Console.WriteLine(result.GetProperty("displayDescription").ToString());
                Console.WriteLine(result.GetProperty("category").ToString());
                Console.WriteLine(result.GetProperty("metricClass").ToString());
                Console.WriteLine(result.GetProperty("unit").ToString());
                Console.WriteLine(result.GetProperty("primaryAggregationType").ToString());
                Console.WriteLine(result.GetProperty("supportedAggregationTypes")[0].ToString());
                Console.WriteLine(result.GetProperty("metricAvailabilities")[0].GetProperty("timeGrain").ToString());
                Console.WriteLine(result.GetProperty("metricAvailabilities")[0].GetProperty("retention").ToString());
                Console.WriteLine(result.GetProperty("id").ToString());
                Console.WriteLine(result.GetProperty("dimensions")[0].GetProperty("value").ToString());
                Console.WriteLine(result.GetProperty("dimensions")[0].GetProperty("localizedValue").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetMetricDefinitions_AllParameters_Async()
        {
            MetricDefinitionsClient client = new MetricDefinitionsClient(null);

            await foreach (BinaryData item in client.GetMetricDefinitionsAsync("<resourceUri>", "<metricnamespace>", null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("isDimensionRequired").ToString());
                Console.WriteLine(result.GetProperty("resourceId").ToString());
                Console.WriteLine(result.GetProperty("namespace").ToString());
                Console.WriteLine(result.GetProperty("name").GetProperty("value").ToString());
                Console.WriteLine(result.GetProperty("name").GetProperty("localizedValue").ToString());
                Console.WriteLine(result.GetProperty("displayDescription").ToString());
                Console.WriteLine(result.GetProperty("category").ToString());
                Console.WriteLine(result.GetProperty("metricClass").ToString());
                Console.WriteLine(result.GetProperty("unit").ToString());
                Console.WriteLine(result.GetProperty("primaryAggregationType").ToString());
                Console.WriteLine(result.GetProperty("supportedAggregationTypes")[0].ToString());
                Console.WriteLine(result.GetProperty("metricAvailabilities")[0].GetProperty("timeGrain").ToString());
                Console.WriteLine(result.GetProperty("metricAvailabilities")[0].GetProperty("retention").ToString());
                Console.WriteLine(result.GetProperty("id").ToString());
                Console.WriteLine(result.GetProperty("dimensions")[0].GetProperty("value").ToString());
                Console.WriteLine(result.GetProperty("dimensions")[0].GetProperty("localizedValue").ToString());
            }
        }
    }
}
