// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.Monitor.Query.Models
{
    /// <summary> Model factory for models. </summary>
    public static partial class MonitorQueryModelFactory
    {
        /// <summary> Initializes a new instance of <see cref="Models.MetricAvailability"/>. </summary>
        /// <param name="granularity"> The time grain specifies a supported aggregation interval for the metric. Expressed as a duration 'PT1M', 'P1D', etc. </param>
        /// <param name="retention"> The retention period for the metric at the specified timegrain.  Expressed as a duration 'PT1M', 'P1D', etc. </param>
        /// <returns> A new <see cref="Models.MetricAvailability"/> instance for mocking. </returns>
        public static MetricAvailability MetricAvailability(TimeSpan? granularity = null, TimeSpan? retention = null)
        {
            return new MetricAvailability(granularity, retention);
        }

        /// <summary> Initializes a new instance of <see cref="Models.MetricsQueryResourcesResult"/>. </summary>
        /// <param name="values"> The collection of metric data responses per resource, per metric. </param>
        /// <returns> A new <see cref="Models.MetricsQueryResourcesResult"/> instance for mocking. </returns>
        public static MetricsQueryResourcesResult MetricsQueryResourcesResult(IEnumerable<MetricsQueryResult> values = null)
        {
            values ??= new List<MetricsQueryResult>();

            return new MetricsQueryResourcesResult(values?.ToList());
        }

        /// <summary> Initializes a new instance of <see cref="Models.LogsTableColumn"/>. </summary>
        /// <param name="name"> The name of this column. </param>
        /// <param name="type"> The data type of this column. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="name"/> is null. </exception>
        /// <returns> A new <see cref="Models.LogsTableColumn"/> instance for mocking. </returns>
        public static LogsTableColumn LogsTableColumn(string name = null, LogsColumnType type = default)
        {
            if (name == null)
            {
                throw new ArgumentNullException(nameof(name));
            }

            return new LogsTableColumn(name, type);
        }
    }
}
