// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Monitor.Query.Models
{
    internal static partial class ResultTypeExtensions
    {
        public static string ToSerialString(this ResultType value) => value switch
        {
            ResultType.Data => "Data",
            ResultType.Metadata => "Metadata",
            _ => throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ResultType value.")
        };

        public static ResultType ToResultType(this string value)
        {
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Data")) return ResultType.Data;
            if (StringComparer.OrdinalIgnoreCase.Equals(value, "Metadata")) return ResultType.Metadata;
            throw new ArgumentOutOfRangeException(nameof(value), value, "Unknown ResultType value.");
        }
    }
}
