// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;

namespace Azure.Monitor.Query.Models
{
    /// <summary> The response to a metrics query. </summary>
    public partial class MetricsQueryResult
    {
        /// <summary> Initializes a new instance of <see cref="MetricsQueryResult"/>. </summary>
        /// <param name="timespan"> The timespan for which the data was retrieved. Its value consists of two datetimes concatenated, separated by '/'.  This may be adjusted in the future and returned back from what was originally requested. </param>
        /// <param name="metrics"> The value of the collection. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="timespan"/> or <paramref name="metrics"/> is null. </exception>
        internal MetricsQueryResult(string timespan, IEnumerable<MetricResult> metrics)
        {
            Argument.AssertNotNull(timespan, nameof(timespan));
            Argument.AssertNotNull(metrics, nameof(metrics));

            _timespan = timespan;
            Metrics = metrics.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="MetricsQueryResult"/>. </summary>
        /// <param name="cost"> The integer value representing the relative cost of the query. </param>
        /// <param name="timespan"> The timespan for which the data was retrieved. Its value consists of two datetimes concatenated, separated by '/'.  This may be adjusted in the future and returned back from what was originally requested. </param>
        /// <param name="granularity">
        /// The interval (window size) for which the metric data was returned in ISO 8601 duration format with a special case for 'FULL' value that returns single datapoint for entire time span requested (*Examples: PT15M, PT1H, P1D, FULL*).
        /// This may be adjusted and different from what was originally requested if AutoAdjustTimegrain=true is specified. This is not present if a metadata request was made.
        /// </param>
        /// <param name="namespace"> The namespace of the metrics being queried. </param>
        /// <param name="resourceRegion"> The region of the resource being queried for metrics. </param>
        /// <param name="metrics"> The value of the collection. </param>
        internal MetricsQueryResult(int? cost, string timespan, TimeSpan? granularity, string @namespace, string resourceRegion, IReadOnlyList<MetricResult> metrics)
        {
            Cost = cost;
            _timespan = timespan;
            Granularity = granularity;
            Namespace = @namespace;
            ResourceRegion = resourceRegion;
            Metrics = metrics;
        }

        /// <summary> The integer value representing the relative cost of the query. </summary>
        public int? Cost { get; }
        /// <summary> The namespace of the metrics being queried. </summary>
        public string Namespace { get; }
    }
}
