// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;

namespace Azure.Monitor.Query.Models
{
    public partial class MetricsQueryResourcesResult
    {
        internal static MetricsQueryResourcesResult DeserializeMetricsQueryResourcesResult(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IReadOnlyList<MetricsQueryResult> values = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("values"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<MetricsQueryResult> array = new List<MetricsQueryResult>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(MetricsQueryResult.DeserializeMetricsQueryResult(item));
                    }
                    values = array;
                    continue;
                }
            }
            return new MetricsQueryResourcesResult(values ?? new ChangeTrackingList<MetricsQueryResult>());
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static MetricsQueryResourcesResult FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeMetricsQueryResourcesResult(document.RootElement);
        }
    }
}
