// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Collections.Generic;
using System.Text.Json;

namespace Azure.Monitor.Query.Models
{
    internal partial class MetricsBatchResultValues
    {
        internal static MetricsBatchResultValues DeserializeMetricsBatchResultValues(JsonElement element)
        {
            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string starttime = default;
            string endtime = default;
            string interval = default;
            string @namespace = default;
            string resourceregion = default;
            string resourceid = default;
            IReadOnlyList<MetricResult> value = default;
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("starttime"u8))
                {
                    starttime = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("endtime"u8))
                {
                    endtime = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("interval"u8))
                {
                    interval = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("namespace"u8))
                {
                    @namespace = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("resourceregion"u8))
                {
                    resourceregion = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("resourceid"u8))
                {
                    resourceid = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("value"u8))
                {
                    List<MetricResult> array = new List<MetricResult>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(MetricResult.DeserializeMetricResult(item));
                    }
                    value = array;
                    continue;
                }
            }
            return new MetricsBatchResultValues(
                starttime,
                endtime,
                interval,
                @namespace,
                resourceregion,
                resourceid,
                value);
        }

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static MetricsBatchResultValues FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeMetricsBatchResultValues(document.RootElement);
        }
    }
}
