// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;

namespace Azure.Monitor.Query.Models
{
    /// <summary> Represents a metric value. </summary>
    public partial class MetricValue
    {
        /// <summary> Initializes a new instance of <see cref="MetricValue"/>. </summary>
        /// <param name="timeStamp"> The timestamp for the metric value in ISO 8601 format. </param>
        internal MetricValue(DateTimeOffset timeStamp)
        {
            TimeStamp = timeStamp;
        }

        /// <summary> Initializes a new instance of <see cref="MetricValue"/>. </summary>
        /// <param name="timeStamp"> The timestamp for the metric value in ISO 8601 format. </param>
        /// <param name="average"> The average value in the time range. </param>
        /// <param name="minimum"> The least value in the time range. </param>
        /// <param name="maximum"> The greatest value in the time range. </param>
        /// <param name="total"> The sum of all of the values in the time range. </param>
        /// <param name="count"> The number of samples in the time range. Can be used to determine the number of values that contributed to the average value. </param>
        internal MetricValue(DateTimeOffset timeStamp, double? average, double? minimum, double? maximum, double? total, double? count)
        {
            TimeStamp = timeStamp;
            Average = average;
            Minimum = minimum;
            Maximum = maximum;
            Total = total;
            Count = count;
        }

        /// <summary> The timestamp for the metric value in ISO 8601 format. </summary>
        public DateTimeOffset TimeStamp { get; }
        /// <summary> The average value in the time range. </summary>
        public double? Average { get; }
        /// <summary> The least value in the time range. </summary>
        public double? Minimum { get; }
        /// <summary> The greatest value in the time range. </summary>
        public double? Maximum { get; }
        /// <summary> The sum of all of the values in the time range. </summary>
        public double? Total { get; }
        /// <summary> The number of samples in the time range. Can be used to determine the number of values that contributed to the average value. </summary>
        public double? Count { get; }
    }
}
