// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Monitor.Query.Models
{
    /// <summary> Reduces the set of data collected. The syntax allowed depends on the operation. See the operation's description for details. </summary>
    internal readonly partial struct MetricResultType : IEquatable<MetricResultType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="MetricResultType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public MetricResultType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DataValue = "Data";
        private const string MetadataValue = "Metadata";

        /// <summary> Data. </summary>
        public static MetricResultType Data { get; } = new MetricResultType(DataValue);
        /// <summary> Metadata. </summary>
        public static MetricResultType Metadata { get; } = new MetricResultType(MetadataValue);
        /// <summary> Determines if two <see cref="MetricResultType"/> values are the same. </summary>
        public static bool operator ==(MetricResultType left, MetricResultType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="MetricResultType"/> values are not the same. </summary>
        public static bool operator !=(MetricResultType left, MetricResultType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="MetricResultType"/>. </summary>
        public static implicit operator MetricResultType(string value) => new MetricResultType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is MetricResultType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(MetricResultType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
